/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.AttributesHelper;
import org.sonatype.nexus.repository.content.ContentRepository;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryAttributesDesEvent;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryAttributesEvent;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryCreatedEvent;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryDeletedEvent;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryPreDeleteEvent;
import org.sonatype.nexus.repository.content.facet.ContentFacetFinder;
import org.sonatype.nexus.repository.content.store.ContentRepositoryDAO;
import org.sonatype.nexus.repository.content.store.ContentRepositoryData;
import org.sonatype.nexus.repository.content.store.ContentStoreEventSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class ContentRepositoryStore<T extends ContentRepositoryDAO>
extends ContentStoreEventSupport<T> {
    private ContentFacetFinder contentFacetFinder;

    @Inject
    public ContentRepositoryStore(DataSessionSupplier sessionSupplier, ContentFacetFinder contentFacetFinder, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
        this.contentFacetFinder = (ContentFacetFinder)((Object)Preconditions.checkNotNull((Object)((Object)contentFacetFinder)));
    }

    @Transactional
    public Collection<ContentRepository> browseContentRepositories() {
        return ((ContentRepositoryDAO)this.dao()).browseContentRepositories();
    }

    @Transactional
    public void createContentRepository(ContentRepositoryData contentRepository) {
        ((ContentRepositoryDAO)this.dao()).createContentRepository(contentRepository);
        this.postCommitEvent(() -> new ContentRepositoryCreatedEvent(contentRepository));
    }

    @Transactional
    public Optional<ContentRepository> readContentRepository(EntityId configRepositoryId) {
        return ((ContentRepositoryDAO)this.dao()).readContentRepository(configRepositoryId);
    }

    @Transactional
    public void updateContentRepositoryAttributes(ContentRepository contentRepository, AttributeOperation change, String key, @Nullable Object value) {
        ((ContentRepositoryDAO)this.dao()).readContentRepositoryAttributes(contentRepository).ifPresent(attributes -> {
            ((ContentRepositoryData)contentRepository).setAttributes((NestedAttributesMap)attributes);
            if (AttributesHelper.applyAttributeChange((AttributesMap)attributes, change, key, value)) {
                ((ContentRepositoryDAO)this.dao()).updateContentRepositoryAttributes(contentRepository);
                this.postCommitEvent(() -> new ContentRepositoryAttributesEvent(contentRepository, change, key, value));
                this.contentFacetFinder.findRepository(this.format, contentRepository).ifPresent(repository -> {
                    String repoName = repository.getName();
                    this.postCommitEvent(() -> new ContentRepositoryAttributesDesEvent(repoName));
                });
            }
        });
    }

    @Transactional
    public boolean deleteContentRepository(ContentRepository contentRepository) {
        this.preCommitEvent(() -> new ContentRepositoryPreDeleteEvent(contentRepository));
        boolean deleted = ((ContentRepositoryDAO)this.dao()).deleteContentRepository(contentRepository);
        if (deleted) {
            this.postCommitEvent(() -> new ContentRepositoryDeletedEvent(contentRepository, this.format));
        }
        return deleted;
    }

    @Transactional
    public boolean deleteContentRepository(EntityId configRepositoryId) {
        return ((ContentRepositoryDAO)this.dao()).readContentRepository(configRepositoryId).map(this::deleteContentRepository).orElse(false);
    }

    @Transactional
    public Optional<Map<String, Object>> readContentRepositoryId(String repositoryFormat, String repositoryName) {
        return ((ContentRepositoryDAO)this.dao()).readContentRepositoryId(repositoryFormat, repositoryName);
    }

    @Transactional
    public List<Map<String, Object>> readAllContentRepositoryIds(List<String> repositoryFormats) {
        return ((ContentRepositoryDAO)this.dao()).readAllContentRepositoryIds(repositoryFormats);
    }
}

