/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.inject.assistedinject.Assisted;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.AttributesHelper;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.ComponentSet;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.event.component.ComponentAttributesEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentKindEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPreDeleteEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPrePurgeEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentsPurgedAuditEvent;
import org.sonatype.nexus.repository.content.event.component.RepositoryDeletedComponentEvent;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.store.ComponentDAO;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ComponentSetData;
import org.sonatype.nexus.repository.content.store.ContentStoreEventSupport;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class ComponentStore<T extends ComponentDAO>
extends ContentStoreEventSupport<T> {
    private static final int BATCH_SIZE = SystemPropertiesHelper.getInteger((String)"nexus.component.purge.size", (int)100);
    private final boolean clustered;

    @Inject
    public ComponentStore(DataSessionSupplier sessionSupplier, @Named(value="${nexus.datastore.clustered.enabled:-false}") @Named(value="${nexus.datastore.clustered.enabled:-false}") boolean clustered, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
        this.clustered = clustered;
    }

    @Transactional
    public int countComponents(int repositoryId, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((ComponentDAO)this.dao()).countComponents(repositoryId, kind, filter, filterParams);
    }

    @Transactional
    public int countUnnormalized() {
        return ((ComponentDAO)this.dao()).countUnnormalized();
    }

    @Transactional
    public Continuation<Component> browseComponents(int repositoryId, int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((ComponentDAO)this.dao()).browseComponents(repositoryId, limit, continuationToken, kind, filter, filterParams);
    }

    @Transactional
    public Continuation<ComponentData> browseComponentsEager(Set<Integer> repositoryIds, int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((ComponentDAO)this.dao()).browseComponentsEager(repositoryIds, limit, continuationToken, kind, filter, filterParams);
    }

    @Transactional
    public Continuation<ComponentData> browseUnnormalized(int limit, @Nullable String continuationToken) {
        return ((ComponentDAO)this.dao()).browseUnnormalized(limit, continuationToken);
    }

    @Transactional
    public Continuation<Component> browseComponents(Set<Integer> repositoryIds, int limit, @Nullable String continuationToken) {
        return ((ComponentDAO)this.dao()).browseComponentsInRepositories(repositoryIds, limit, continuationToken);
    }

    @Transactional
    public Continuation<Component> browseComponentsBySet(int repositoryId, ComponentSet componentSet, int limit, @Nullable String continuationToken) {
        return ((ComponentDAO)this.dao()).browseComponentsBySet(repositoryId, componentSet.namespace(), componentSet.name(), limit, continuationToken);
    }

    @Transactional
    public Continuation<Component> selectComponents(SqlGenerator<? extends SqlQueryParameters> generator, SqlQueryParameters params) {
        return ((ComponentDAO)this.dao()).selectComponents(generator, params);
    }

    @Transactional
    public Continuation<Component> selectComponentsWithAssets(SqlGenerator<? extends SqlQueryParameters> generator, SqlQueryParameters params) {
        return ((ComponentDAO)this.dao()).selectComponentsWithAssets(generator, params);
    }

    @Transactional
    public Collection<String> browseNamespaces(int repositoryId) {
        return ((ComponentDAO)this.dao()).browseNamespaces(repositoryId);
    }

    @Transactional
    public Collection<String> browseNames(int repositoryId, String namespace) {
        return ((ComponentDAO)this.dao()).browseNames(repositoryId, namespace);
    }

    @Transactional
    public Continuation<ComponentSetData> browseSets(@Param(value="repositoryId") int repositoryId, @Param(value="limit") int limit, @Nullable @Param(value="continuationToken") String continuationToken) {
        return ((ComponentDAO)this.dao()).browseSets(repositoryId, limit, continuationToken);
    }

    @Transactional
    public Collection<String> browseVersions(int repositoryId, String namespace, String name) {
        return ((ComponentDAO)this.dao()).browseVersions(repositoryId, namespace, name);
    }

    @Transactional
    public void createComponent(ComponentData component) {
        ((ComponentDAO)this.dao()).createComponent(component, this.clustered);
        this.postCommitEvent(() -> new ComponentCreatedEvent(component));
    }

    @Transactional
    public Optional<Component> readComponent(int componentId) {
        return ((ComponentDAO)this.dao()).readComponent(componentId);
    }

    @Transactional
    public Optional<Component> readCoordinate(int repositoryId, String namespace, String name, String version) {
        return ((ComponentDAO)this.dao()).readCoordinate(repositoryId, namespace, name, version);
    }

    @Transactional
    public void updateComponentKind(Component component) {
        ((ComponentDAO)this.dao()).updateComponentKind(component, this.clustered);
        this.postCommitEvent(() -> new ComponentKindEvent(component));
    }

    @Transactional
    public void updateComponentNormalizedVersion(Component component) {
        ((ComponentDAO)this.dao()).updateComponentNormalizedVersion(component, this.clustered);
    }

    @Transactional
    public void updateComponentAttributes(Component component, AttributeOperation change, String key, @Nullable Object value) {
        ((ComponentDAO)this.dao()).readComponentAttributes(component).ifPresent(attributes -> {
            ((ComponentData)component).setAttributes((NestedAttributesMap)attributes);
            if (AttributesHelper.applyAttributeChange((AttributesMap)attributes, change, key, value)) {
                ((ComponentDAO)this.dao()).updateComponentAttributes(component, this.clustered);
                this.postCommitEvent(() -> new ComponentAttributesEvent(component, change, key, value));
            }
        });
    }

    @Transactional
    public boolean deleteComponent(Component component) {
        this.preCommitEvent(() -> new ComponentPreDeleteEvent(component));
        boolean deleted = ((ComponentDAO)this.dao()).deleteComponent(component);
        if (deleted) {
            this.postCommitEvent(() -> new ComponentDeletedEvent(component));
        }
        return deleted;
    }

    @Transactional
    public boolean deleteCoordinate(int repositoryId, String namespace, String name, String version) {
        return ((ComponentDAO)this.dao()).readCoordinate(repositoryId, namespace, name, version).map(this::deleteComponent).orElse(false);
    }

    @Transactional
    public void deleteComponents(int repositoryId) {
        int deletedCount;
        this.log.debug("Deleting all components in repository {}", (Object)repositoryId);
        while ((deletedCount = ((ComponentDAO)this.dao()).deleteComponents(repositoryId, this.deleteBatchSize())) > 0) {
            int finalDeletedCount = deletedCount;
            this.postCommitEvent(() -> new RepositoryDeletedComponentEvent(repositoryId, finalDeletedCount));
            CancelableHelper.checkCancellation();
        }
        this.log.debug("Deleted all components in repository {}", (Object)repositoryId);
    }

    @Transactional
    public int purgeNotRecentlyDownloaded(int repositoryId, int daysAgo) {
        int[] componentIds;
        int purged = 0;
        while ((componentIds = ((ComponentDAO)this.dao()).selectNotRecentlyDownloaded(repositoryId, daysAgo, this.deleteBatchSize())).length != 0) {
            purged += this.purge(repositoryId, componentIds);
            CancelableHelper.checkCancellation();
        }
        return purged;
    }

    public int purge(int repositoryId, int[] componentIds) {
        int iterations = componentIds.length / BATCH_SIZE + 1;
        int purged = 0;
        int i = 0;
        while (i < iterations) {
            int startIndex = i * BATCH_SIZE;
            int[] page = new int[Math.min(BATCH_SIZE, componentIds.length - startIndex)];
            System.arraycopy(componentIds, startIndex, page, 0, page.length);
            purged += this.purgeBatch(repositoryId, page, Optional.empty());
            ++i;
        }
        return purged;
    }

    public int purge(Integer repositoryId, List<FluentComponent> components) {
        int iterations = components.size() / BATCH_SIZE + 1;
        int purged = 0;
        int i = 0;
        while (i < iterations) {
            int start = i * BATCH_SIZE;
            int end = Math.min(start + BATCH_SIZE, components.size());
            List<FluentComponent> page = components.subList(start, end);
            int[] componentIds = page.stream().mapToInt(InternalIds::internalComponentId).toArray();
            purged += this.purgeBatch(repositoryId, componentIds, Optional.of(page));
            ++i;
        }
        return purged;
    }

    @Transactional
    protected int purgeBatch(int repositoryId, int[] componentIds, Optional<List<FluentComponent>> components) {
        int purged = 0;
        if (componentIds.length == 0) {
            return purged;
        }
        purged = "H2".equals(this.thisSession().sqlDialect()) ? (purged += ((ComponentDAO)this.dao()).purgeSelectedComponents((Integer[])Arrays.stream(componentIds).boxed().toArray(Integer[]::new))) : (purged += ((ComponentDAO)this.dao()).purgeSelectedComponents(componentIds));
        components.ifPresent(c -> this.postCommitEvent(() -> new ComponentsPurgedAuditEvent(repositoryId, Collections.unmodifiableList(c))));
        this.preCommitEvent(() -> new ComponentPrePurgeEvent(repositoryId, componentIds));
        this.postCommitEvent(() -> new ComponentPurgedEvent(repositoryId, componentIds));
        return purged;
    }
}

