/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.SelectProvider;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.ContentDataAccess;
import org.sonatype.nexus.datastore.api.Expects;
import org.sonatype.nexus.datastore.api.SchemaTemplate;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.SqlAdapter;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ComponentSetData;
import org.sonatype.nexus.repository.content.store.ContentRepositoryDAO;

@Expects(value={ContentRepositoryDAO.class})
@SchemaTemplate(value="format")
public interface ComponentDAO
extends ContentDataAccess {
    public static final String FILTER_PARAMS = "filterParams";

    public int countComponents(@Param(value="repositoryId") int var1, @Nullable @Param(value="kind") String var2, @Nullable @Param(value="filter") String var3, @Nullable @Param(value="filterParams") Map<String, Object> var4);

    public int countUnnormalized();

    public Continuation<Component> browseComponents(@Param(value="repositoryId") int var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3, @Nullable @Param(value="kind") String var4, @Nullable @Param(value="filter") String var5, @Nullable @Param(value="filterParams") Map<String, Object> var6);

    public Continuation<ComponentData> browseComponentsEager(@Param(value="repositoryIds") Set<Integer> var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3, @Nullable @Param(value="kind") String var4, @Nullable @Param(value="filter") String var5, @Nullable @Param(value="filterParams") Map<String, Object> var6);

    public Continuation<ComponentData> browseUnnormalized(@Param(value="limit") int var1, @Nullable @Param(value="continuationToken") String var2);

    public Continuation<Component> browseComponentsInRepositories(@Param(value="repositoryIds") Set<Integer> var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3);

    public Continuation<Component> browseComponentsBySet(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2, @Param(value="name") String var3, @Param(value="limit") int var4, @Nullable @Param(value="continuationToken") String var5);

    @ResultMap(value={"ComponentDataMap"})
    @ResultType(value=ComponentData.class)
    @SelectProvider(type=SqlAdapter.class, method="select")
    public Continuation<Component> selectComponents(SqlGenerator<? extends SqlQueryParameters> var1, @Param(value="params") SqlQueryParameters var2);

    @ResultMap(value={"ComponentAssetsDataMap"})
    @ResultType(value=ComponentData.class)
    @SelectProvider(type=SqlAdapter.class, method="select")
    public Continuation<Component> selectComponentsWithAssets(SqlGenerator<? extends SqlQueryParameters> var1, @Param(value="params") SqlQueryParameters var2);

    public Collection<String> browseNamespaces(@Param(value="repositoryId") int var1);

    public Collection<String> browseNames(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2);

    public Continuation<ComponentSetData> browseSets(@Param(value="repositoryId") int var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3);

    public Collection<String> browseVersions(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2, @Param(value="name") String var3);

    public void createComponent(@Param(value="component") ComponentData var1, @Param(value="entityVersionEnabled") boolean var2);

    public Optional<Component> readComponent(@Param(value="componentId") int var1);

    public Optional<Component> readCoordinate(@Param(value="repositoryId") int var1, @Param(value="namespace") String var2, @Param(value="name") String var3, @Param(value="version") String var4);

    public void updateComponentKind(@Param(value="component") Component var1, @Param(value="entityVersionEnabled") boolean var2);

    public void updateComponentNormalizedVersion(@Param(value="component") Component var1, @Param(value="entityVersionEnabled") boolean var2);

    public Optional<NestedAttributesMap> readComponentAttributes(Component var1);

    public void updateComponentAttributes(@Param(value="component") Component var1, @Param(value="entityVersionEnabled") boolean var2);

    public boolean deleteComponent(Component var1);

    public int deleteComponents(@Param(value="repositoryId") int var1, @Param(value="limit") int var2);

    public int[] selectNotRecentlyDownloaded(@Param(value="repositoryId") int var1, @Param(value="daysAgo") int var2, @Param(value="limit") int var3);

    public int purgeSelectedComponents(@Param(value="componentIds") int[] var1);

    public int purgeSelectedComponents(@Param(value="componentIds") Integer[] var1);
}

