/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.datastore.mybatis.handlers.ContentTypeHandler;

@Named
@Singleton
public class BlobRefTypeHandler
extends BaseTypeHandler<BlobRef>
implements ContentTypeHandler<BlobRef> {
    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, BlobRef parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, BlobRefTypeHandler.toPersistableString(parameter));
    }

    public BlobRef getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.nullableBlobRef(rs.getString(columnName));
    }

    public BlobRef getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.nullableBlobRef(rs.getString(columnIndex));
    }

    public BlobRef getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.nullableBlobRef(cs.getString(columnIndex));
    }

    @Nullable
    private BlobRef nullableBlobRef(@Nullable String blobRef) {
        return blobRef != null ? BlobRefTypeHandler.parsePersistableFormat(blobRef) : null;
    }

    public static String toPersistableString(BlobRef blobRef) {
        return blobRef.toString();
    }

    public static BlobRef parsePersistableFormat(String spec) {
        return BlobRef.parse((String)spec);
    }
}

