/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.ContinuationAware;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.store.AbstractRepositoryContent;
import org.sonatype.nexus.repository.content.store.InternalIds;

public class AssetData
extends AbstractRepositoryContent
implements Asset,
ContinuationAware {
    Integer assetId;
    private String path;
    private String kind;
    @Nullable
    Integer componentId;
    @Nullable
    private Component component;
    @Nullable
    Integer assetBlobId;
    @Nullable
    private AssetBlob assetBlob;
    @Nullable
    private OffsetDateTime lastDownloaded;

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String kind() {
        return this.kind;
    }

    @Override
    public Optional<Component> component() {
        return Optional.ofNullable(this.getComponent());
    }

    @Override
    public Optional<AssetBlob> blob() {
        return Optional.ofNullable(this.getAssetBlob());
    }

    @Override
    public Optional<OffsetDateTime> lastDownloaded() {
        return Optional.ofNullable(this.lastDownloaded);
    }

    public void setAssetId(int assetId) {
        this.assetId = assetId;
    }

    public void setAssetBlobId(Integer assetBlobId) {
        this.assetBlobId = assetBlobId;
    }

    public void setPath(String path) {
        Preconditions.checkArgument((path != null && path.charAt(0) == '/' ? 1 : 0) != 0, (Object)"Paths must start with a slash");
        this.path = path;
    }

    public void setKind(String kind) {
        this.kind = (String)Preconditions.checkNotNull((Object)kind);
    }

    public void setComponent(@Nullable Component component) {
        this.componentId = component != null ? Integer.valueOf(InternalIds.internalComponentId(component)) : null;
        this.component = component;
    }

    public void setAssetBlob(@Nullable AssetBlob assetBlob) {
        this.assetBlobId = assetBlob != null ? Integer.valueOf(InternalIds.internalAssetBlobId(assetBlob)) : null;
        this.assetBlob = assetBlob;
    }

    @Override
    public boolean hasBlob() {
        return this.assetBlobId != null;
    }

    public void setLastDownloaded(@Nullable OffsetDateTime lastDownloaded) {
        this.lastDownloaded = lastDownloaded;
    }

    @Nullable
    protected Component getComponent() {
        return this.component;
    }

    @Nullable
    protected AssetBlob getAssetBlob() {
        return this.assetBlob;
    }

    public String nextContinuationToken() {
        return Integer.toString(this.assetId);
    }

    @Override
    public String toString() {
        return "AssetData{assetId=" + this.assetId + ", path='" + this.path + '\'' + ", kind='" + this.kind + '\'' + ", componentId=" + this.componentId + ", component=" + this.component + ", assetBlobId=" + this.assetBlobId + ", assetBlob=" + this.assetBlob + ", lastDownloaded=" + this.lastDownloaded + "} " + super.toString();
    }
}

