/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.ContentDataAccess;
import org.sonatype.nexus.datastore.api.Expects;
import org.sonatype.nexus.datastore.api.SchemaTemplate;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetInfo;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.store.AssetBlobDAO;
import org.sonatype.nexus.repository.content.store.AssetData;
import org.sonatype.nexus.repository.content.store.ComponentDAO;
import org.sonatype.nexus.repository.content.store.ContentRepositoryDAO;

@Expects(value={ContentRepositoryDAO.class, ComponentDAO.class, AssetBlobDAO.class})
@SchemaTemplate(value="format")
public interface AssetDAO
extends ContentDataAccess {
    public static final String FILTER_PARAMS = "filterParams";

    public int countAssets(@Param(value="repositoryId") int var1, @Nullable @Param(value="kind") String var2, @Nullable @Param(value="filter") String var3, @Nullable @Param(value="filterParams") Map<String, Object> var4);

    public Continuation<Asset> browseAssets(@Param(value="repositoryId") int var1, @Param(value="limit") int var2, @Nullable @Param(value="continuationToken") String var3, @Nullable @Param(value="kind") String var4, @Nullable @Param(value="filter") String var5, @Nullable @Param(value="filterParams") Map<String, Object> var6);

    public Continuation<Asset> browseEagerAssetsInRepository(@Param(value="repositoryId") int var1, @Nullable @Param(value="continuationToken") String var2, @Param(value="limit") int var3);

    public Continuation<Asset> browseAssetsInRepositories(@Param(value="repositoryIds") Set<Integer> var1, @Nullable @Param(value="continuationToken") String var2, @Nullable @Param(value="kind") String var3, @Nullable @Param(value="filter") String var4, @Nullable @Param(value="filterParams") Map<String, Object> var5, @Param(value="limit") int var6);

    public Collection<Asset> browseComponentAssets(Component var1);

    public List<AssetInfo> findGreaterThanOrEqualToAddedToRepository(@Param(value="repositoryId") int var1, @Nullable @Param(value="addedToRepository") OffsetDateTime var2, @Param(value="regexList") List<String> var3, @Nullable @Param(value="filter") String var4, @Nullable @Param(value="filterParams") Map<String, Object> var5, @Param(value="limit") int var6);

    public List<AssetInfo> findAddedToRepositoryWithinRange(@Param(value="repositoryId") int var1, @Param(value="startAddedToRepository") OffsetDateTime var2, @Param(value="endAddedToRepository") OffsetDateTime var3, @Param(value="regexList") List<String> var4, @Nullable @Param(value="filter") String var5, @Nullable @Param(value="filterParams") Map<String, Object> var6, @Param(value="limit") int var7);

    public int createAsset(@Param(value="asset") AssetData var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public Optional<Asset> readAsset(@Param(value="assetId") int var1);

    public Optional<Asset> readPath(@Param(value="repositoryId") int var1, @Param(value="path") String var2);

    public Collection<Asset> readPathsFromRepository(@Param(value="repositoryId") int var1, @Param(value="paths") List<String> var2);

    public Optional<Asset> findByBlobRef(@Param(value="repositoryId") int var1, @Param(value="blobRef") BlobRef var2);

    public Collection<AssetInfo> findByComponentIds(@Param(value="componentIds") Set<Integer> var1);

    public void updateAssetKind(@Param(value="asset") Asset var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public Optional<NestedAttributesMap> readAssetAttributes(Asset var1);

    public void updateAssetAttributes(@Param(value="asset") Asset var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public void updateAssetBlobLink(@Param(value="asset") Asset var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public void markAsDownloaded(Asset var1);

    public boolean deleteAsset(Asset var1);

    public boolean deleteAssets(@Param(value="repositoryId") int var1, @Param(value="limit") int var2);

    public int[] selectNotRecentlyDownloaded(@Param(value="repositoryId") int var1, @Param(value="daysAgo") int var2, @Param(value="limit") int var3);

    public int purgeSelectedAssets(@Param(value="assetIds") int[] var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public int purgeSelectedAssets(@Param(value="assetIds") Integer[] var1);

    public void created(@Param(value="assetId") int var1, @Param(value="created") OffsetDateTime var2);

    public void lastDownloaded(@Param(value="assetId") int var1, @Param(value="lastDownloaded") OffsetDateTime var2);

    public void lastUpdated(@Param(value="assetId") int var1, @Param(value="lastUpdated") OffsetDateTime var2);

    public void updateEntityVersion(@Param(value="componentId") int var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public void updateEntityVersions(@Param(value="componentIds") int[] var1, @Param(value="updateComponentEntityVersion") boolean var2);

    public int[] selectComponentIds(@Param(value="assetIds") int[] var1);
}

