/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.store;

import com.google.inject.assistedinject.Assisted;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.store.AssetBlobDAO;
import org.sonatype.nexus.repository.content.store.AssetBlobData;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class AssetBlobStore<T extends AssetBlobDAO>
extends ContentStoreSupport<T> {
    @Inject
    public AssetBlobStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public Continuation<AssetBlob> browseUnusedAssetBlobs(int limit, int blobCreatedDelayMinute, @Nullable String continuationToken) {
        return ((AssetBlobDAO)this.dao()).browseUnusedAssetBlobs(limit, blobCreatedDelayMinute, continuationToken);
    }

    @Transactional
    public Continuation<AssetBlob> browseAssetBlobs(int limit, @Nullable String continuationToken) {
        return ((AssetBlobDAO)this.dao()).browseAssetBlobs(limit, continuationToken);
    }

    @Transactional
    public void createAssetBlob(AssetBlobData assetBlob) {
        ((AssetBlobDAO)this.dao()).createAssetBlob(assetBlob);
    }

    @Transactional
    public Optional<AssetBlob> readAssetBlob(BlobRef blobRef) {
        return ((AssetBlobDAO)this.dao()).readAssetBlob(blobRef);
    }

    @Transactional
    public boolean deleteAssetBlob(BlobRef blobRef) {
        return ((AssetBlobDAO)this.dao()).deleteAssetBlob(blobRef);
    }

    @Transactional
    public boolean deleteAssetBlobBatch(String[] blobRefIds) {
        return ((AssetBlobDAO)this.dao()).deleteAssetBlobBatch(blobRefIds);
    }

    @Transactional
    public void setBlobCreated(AssetBlob blob, OffsetDateTime blobCreated) {
        ((AssetBlobDAO)this.dao()).setBlobCreated(blob.blobRef(), blobCreated);
    }

    @Transactional
    public void setAddedToRepository(AssetBlob blob, OffsetDateTime addedToRepository) {
        ((AssetBlobDAO)this.dao()).setAddedToRepository(blob.blobRef(), addedToRepository);
    }

    @Transactional
    public void setContentType(AssetBlob blob, String contentType) {
        ((AssetBlobDAO)this.dao()).setContentType(blob.blobRef(), contentType);
    }

    @Transactional
    public void setChecksums(AssetBlob blob, Map<String, String> checksums) {
        ((AssetBlobDAO)this.dao()).setChecksums(blob.blobRef(), checksums);
    }

    @Transactional
    public void setCreatedBy(AssetBlob blob, String createdBy) {
        ((AssetBlobDAO)this.dao()).setCreatedBy(blob.blobRef(), createdBy);
    }

    @Transactional
    public void setCreatedByIP(AssetBlob blob, String createdByIP) {
        ((AssetBlobDAO)this.dao()).setCreatedByIP(blob.blobRef(), createdByIP);
    }

    @Transactional
    public Continuation<AssetBlob> browseAssetsWithLegacyBlobRef(int limit, @Nullable String continuationToken) {
        return ((AssetBlobDAO)this.dao()).browseAssetsWithLegacyBlobRef(limit, continuationToken);
    }

    @Transactional
    public boolean updateBlobRefs(@Param(value="assetBlobs") Collection<AssetBlob> assetBlobs) {
        return ((AssetBlobDAO)this.dao()).updateBlobRefs(assetBlobs);
    }

    @Transactional
    public boolean updateBlobRef(@Param(value="assetBlobData") AssetBlob assetBlob) {
        return ((AssetBlobDAO)this.dao()).updateBlobRef(assetBlob);
    }

    @Transactional
    public boolean notMigratedAssetBlobRefsExists() {
        return ((AssetBlobDAO)this.dao()).countNotMigratedAssetBlobs() > 0;
    }
}

