/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.upgrade;

import java.sql.Connection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.content.search.upgrade.SearchIndexUpgrade;

@Named
public class SqlSearchMigrationStep_1_29
extends SearchIndexUpgrade {
    private final String RENAME_QUERY = "ALTER TABLE search_components RENAME COLUMN component_created TO last_modified;";
    private final String NOT_NULL_QUERY = "ALTER TABLE search_components ALTER COLUMN last_modified DROP NOT NULL;";
    private final String TABLE = "search_components";
    private final String COMPONENT_CREATED = "component_created";
    private final String LAST_MODIFIED = "last_modified";
    private final boolean sqlSearchEnabled;

    @Inject
    public SqlSearchMigrationStep_1_29(@Named(value="${nexus.datastore.table.search.enabled:-false}") @Named(value="${nexus.datastore.table.search.enabled:-false}") boolean sqlSearchEnabled) {
        this.sqlSearchEnabled = sqlSearchEnabled;
    }

    public Optional<String> version() {
        return Optional.of("1.29");
    }

    @Override
    public void migrate(Connection connection) throws Exception {
        if (this.isPostgresql(connection) && this.columnExists(connection, "search_components", "component_created")) {
            this.log.info(String.format("Renaming column %s to %s", "component_created", "last_modified"));
            this.runStatement(connection, "ALTER TABLE search_components RENAME COLUMN component_created TO last_modified;");
            this.log.info(String.format("Dropping null constraint", new Object[0]));
            this.runStatement(connection, "ALTER TABLE search_components ALTER COLUMN last_modified DROP NOT NULL;");
        }
        if (this.sqlSearchEnabled) {
            super.migrate(connection);
        }
    }
}

