/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.upgrade;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.search.index.SearchUpdateService;

@Named
@Singleton
public class SearchUpdateServiceImpl
implements SearchUpdateService {
    public boolean needsReindex(Repository repository) {
        if ("group".equals(repository.getType().getValue())) {
            return false;
        }
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        Object indexOutdated = contentFacet.attributes().get("search_index_outdated");
        if (indexOutdated instanceof Boolean) {
            return (Boolean)indexOutdated;
        }
        return false;
    }

    public void doneReindexing(Repository repository) {
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        contentFacet.withoutAttribute("search_index_outdated");
    }
}

