/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.elasticsearch;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.search.SearchFacet;
import org.sonatype.nexus.repository.content.search.elasticsearch.SearchDocumentProducer;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.search.index.ElasticSearchIndexService;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class SearchFacetImpl
extends FacetSupport
implements SearchFacet {
    private final ElasticSearchIndexService elasticSearchIndexService;
    private final Map<String, SearchDocumentProducer> searchDocumentProducersByFormat;
    private final int pageSize;
    private final boolean bulkProcessing;
    private SearchDocumentProducer searchDocumentProducer;
    private Map<String, Object> repositoryFields;

    @Inject
    public SearchFacetImpl(ElasticSearchIndexService elasticSearchIndexService, Map<String, SearchDocumentProducer> searchDocumentProducersByFormat, @Named(value="${nexus.elasticsearch.reindex.pageSize:-1000}") @Named(value="${nexus.elasticsearch.reindex.pageSize:-1000}") int pageSize, @Named(value="${nexus.elasticsearch.bulkProcessing:-true}") @Named(value="${nexus.elasticsearch.bulkProcessing:-true}") boolean bulkProcessing) {
        this.elasticSearchIndexService = (ElasticSearchIndexService)Preconditions.checkNotNull((Object)elasticSearchIndexService);
        this.searchDocumentProducersByFormat = (Map)Preconditions.checkNotNull(searchDocumentProducersByFormat);
        this.pageSize = Math.max(pageSize, 1);
        this.bulkProcessing = bulkProcessing;
    }

    protected void doInit(Configuration configuration) throws Exception {
        String format = this.getRepository().getFormat().getValue();
        this.searchDocumentProducer = this.lookupSearchDocumentProducer(format);
        this.repositoryFields = ImmutableMap.of((Object)"repository_name", (Object)this.getRepository().getName(), (Object)"format", (Object)format);
        super.doInit(configuration);
    }

    protected void doStart() throws Exception {
        this.elasticSearchIndexService.createIndex(this.getRepository());
    }

    protected void doDelete() {
        this.elasticSearchIndexService.deleteIndex(this.getRepository());
    }

    @Override
    @Guarded(by={"STARTED"})
    public void index(Collection<EntityId> componentIds) {
        FluentComponents lookup = ((ContentFacet)this.facet(ContentFacet.class)).components();
        Stream<FluentComponent> components = componentIds.stream().map(lookup::find).filter(Optional::isPresent).map(Optional::get);
        Repository repository = this.getRepository();
        if (this.bulkProcessing) {
            this.elasticSearchIndexService.bulkPut(repository, components::iterator, this::identifier, this::document);
        } else {
            components.forEach(c -> this.elasticSearchIndexService.put(repository, this.identifier((FluentComponent)c), this.document((FluentComponent)c)));
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void purge(Collection<EntityId> componentIds) {
        Stream<String> identifiers = componentIds.stream().map(EntityId::getValue);
        Repository repository = this.getRepository();
        if (this.bulkProcessing) {
            this.elasticSearchIndexService.bulkDelete(repository, identifiers::iterator);
        } else {
            identifiers.forEach(id -> this.elasticSearchIndexService.delete(repository, id));
        }
    }

    @Guarded(by={"STARTED"})
    public void rebuildIndex() {
        this.log.info("Rebuilding index of repository {}", (Object)this.getRepository().getName());
        this.elasticSearchIndexService.rebuildIndex(this.getRepository());
        this.rebuildComponentIndex();
    }

    private void rebuildComponentIndex() {
        String repositoryName = this.getRepository().getName();
        try {
            FluentComponents components = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).components();
            long total = components.count();
            if (total > 0L) {
                ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
                Stopwatch sw = Stopwatch.createStarted();
                long processed = 0L;
                Continuation page = components.browse(this.pageSize, null);
                while (!page.isEmpty()) {
                    this.elasticSearchIndexService.bulkPut(this.getRepository(), page, this::identifier, this::document);
                    long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                    progressLogger.info("Indexed {} / {} {} components in {} ms", new Object[]{processed += (long)page.size(), total, repositoryName, elapsed});
                    CancelableHelper.checkCancellation();
                    page = components.browse(this.pageSize, page.nextContinuationToken());
                }
                progressLogger.flush();
            }
        }
        catch (Exception e) {
            this.log.error("Unable to rebuild search index for repository {}", (Object)repositoryName, (Object)e);
        }
    }

    private SearchDocumentProducer lookupSearchDocumentProducer(String format) {
        SearchDocumentProducer producer = this.searchDocumentProducersByFormat.get(format);
        if (producer == null) {
            producer = this.searchDocumentProducersByFormat.get("default");
        }
        Preconditions.checkState((producer != null ? 1 : 0) != 0, (String)"Could not find a component metadata producer for format: %s", (Object)format);
        return producer;
    }

    private String identifier(FluentComponent component) {
        return this.identifier(InternalIds.internalComponentId(component));
    }

    private String identifier(int internalComponentId) {
        return InternalIds.toExternalId(internalComponentId).getValue();
    }

    private String document(FluentComponent component) {
        try {
            return this.searchDocumentProducer.getDocument(component, this.repositoryFields);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn("Error creating search document for {}", (Object)component, (Object)e);
            } else {
                this.log.warn("Error '{}' creating search document for component: {}", (Object)e.getMessage(), (Object)component);
            }
            return null;
        }
    }
}

