/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.search.elasticsearch.SearchDocumentExtension;
import org.sonatype.nexus.repository.content.search.elasticsearch.SearchDocumentProducer;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.search.normalize.VersionNumberExpander;

@Named
@Singleton
public class DefaultSearchDocumentProducer
extends ComponentSupport
implements SearchDocumentProducer {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private final Set<SearchDocumentExtension> documentExtensions;

    @Inject
    public DefaultSearchDocumentProducer(Set<SearchDocumentExtension> documentExtensions) {
        this.documentExtensions = (Set)Preconditions.checkNotNull(documentExtensions);
    }

    @Override
    public String getDocument(FluentComponent component, Map<String, Object> commonFields) {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull(commonFields);
        HashMap<String, Object> componentDoc = new HashMap<String, Object>();
        componentDoc.put("group", component.namespace());
        componentDoc.put("name", component.name());
        componentDoc.put("version", component.version());
        componentDoc.put("attributes", component.attributes().backing());
        componentDoc.put("normalized_version", this.getNormalizedVersion(component));
        componentDoc.put("isPrerelease", this.isPrerelease(component));
        Collection<FluentAsset> assets = component.assets();
        this.lastBlobUpdated(assets).ifPresent(dateTime -> {
            String string = componentDoc.put("lastBlobUpdated", DefaultSearchDocumentProducer.format(dateTime));
        });
        this.lastDownloaded(assets).ifPresent(dateTime -> {
            String string = componentDoc.put("lastDownloaded", DefaultSearchDocumentProducer.format(dateTime));
        });
        ArrayList assetDocs = new ArrayList();
        for (Asset asset : assets) {
            HashMap<String, Object> assetDoc = new HashMap<String, Object>();
            assetDoc.put("id", InternalIds.toExternalId(InternalIds.internalAssetId(asset)).getValue());
            assetDoc.put("name", asset.path());
            HashMap attributes = new HashMap(asset.attributes().backing());
            assetDoc.put("content_type", "");
            asset.blob().ifPresent(blob -> {
                assetDoc.put("content_type", blob.contentType());
                assetDoc.put("uploader", blob.createdBy().orElse(null));
                assetDoc.put("uploaderIp", blob.createdByIp().orElse(null));
                assetDoc.put("fileSize", blob.blobSize());
                asset.lastDownloaded().ifPresent(dateTime -> {
                    String string = assetDoc.put("lastDownloaded", DefaultSearchDocumentProducer.format(dateTime));
                });
                attributes.put("checksum", blob.checksums());
                HashMap<String, Long> content = new HashMap<String, Long>();
                content.put("last_modified", blob.blobCreated().toInstant().toEpochMilli());
                attributes.put("content", content);
            });
            assetDoc.put("attributes", attributes);
            assetDocs.add(assetDoc);
        }
        if (!assetDocs.isEmpty()) {
            componentDoc.put("assets", assetDocs);
        }
        for (SearchDocumentExtension searchDocumentExtension : this.documentExtensions) {
            componentDoc.putAll(searchDocumentExtension.getFields(component));
        }
        componentDoc.putAll(commonFields);
        try {
            return WRITER.writeValueAsString(componentDoc);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    protected boolean isPrerelease(FluentComponent component) {
        return false;
    }

    protected String getNormalizedVersion(FluentComponent component) {
        return VersionNumberExpander.expand((String)component.version());
    }

    @VisibleForTesting
    Optional<OffsetDateTime> lastDownloaded(Collection<? extends Asset> assets) {
        return assets.stream().map(Asset::lastDownloaded).filter(Optional::isPresent).map(Optional::get).max(OffsetDateTime::compareTo);
    }

    @VisibleForTesting
    Optional<OffsetDateTime> lastBlobUpdated(Collection<? extends Asset> assets) {
        return assets.stream().map(Asset::blob).filter(Optional::isPresent).map(Optional::get).map(AssetBlob::blobCreated).max(OffsetDateTime::compareTo);
    }

    private static String format(OffsetDateTime value) {
        return value.format(DATE_TIME_FORMATTER);
    }
}

