/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.search;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.search.ComponentFinder;

@Named
@Singleton
public class DefaultComponentFinder
extends ComponentSupport
implements ComponentFinder {
    @Override
    public Stream<FluentComponent> findComponentsByModel(Repository repository, String searchComponentId, String namespace, String name, String version) {
        Optional<FluentComponent> component = Optional.empty();
        if (repository != null) {
            FluentComponents components = this.contentFacet(repository).components();
            if (searchComponentId != null) {
                component = components.find(EntityHelper.id((String)searchComponentId));
            }
            if (!component.isPresent()) {
                component = components.name(name).namespace(Strings.nullToEmpty((String)namespace)).version(Strings.nullToEmpty((String)version)).find();
            }
        }
        return component.map(Stream::of).orElse(Stream.empty());
    }

    protected ContentFacet contentFacet(Repository repository) {
        return (ContentFacet)repository.facet(ContentFacet.class);
    }
}

