/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.rest.internal.resources.AssetsResourceSupport;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.selector.ContentAuthHelper;

abstract class ComponentsResourceSupport
extends ComponentSupport {
    static final int LIMIT = 100;
    private final ContentAuthHelper contentAuthHelper;
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;

    ComponentsResourceSupport(ContentAuthHelper contentAuthHelper, RepositoryManagerRESTAdapter repositoryManagerRESTAdapter) {
        this.contentAuthHelper = (ContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
    }

    List<FluentComponent> browse(Repository browsedRepository, String continuationToken) {
        ArrayList<FluentComponent> permittedComponents = new ArrayList<FluentComponent>();
        String internalToken = AssetsResourceSupport.toInternalToken(continuationToken);
        Continuation<FluentComponent> componentContinuation = this.getComponents(browsedRepository, internalToken);
        while (permittedComponents.size() < 10 && !componentContinuation.isEmpty()) {
            permittedComponents.addAll(this.removeComponentsNotPermitted(browsedRepository, componentContinuation));
            componentContinuation = this.getComponents(browsedRepository, componentContinuation.nextContinuationToken());
        }
        return AssetsResourceSupport.trim(permittedComponents, 10);
    }

    private Continuation<FluentComponent> getComponents(Repository repository, String continuationToken) {
        if ("group".equals(repository.getType().getValue())) {
            return ((ContentFacet)repository.facet(ContentFacet.class)).components().withOnlyGroupMemberContent().browse(100, continuationToken);
        }
        return ((ContentFacet)repository.facet(ContentFacet.class)).components().browse(100, continuationToken);
    }

    private List<FluentComponent> removeComponentsNotPermitted(Repository repository, Continuation<FluentComponent> assets) {
        return assets.stream().filter(this.componentPermitted(repository.getFormat().getValue(), repository.getName())).collect(Collectors.toList());
    }

    Predicate<FluentComponent> componentPermitted(String format, String repositoryName) {
        return component -> this.contentAuthHelper.checkPathPermissions(component.name(), format, new String[]{repositoryName});
    }

    Predicate<FluentAsset> assetPermitted(Repository repository) {
        String repositoryName = repository.getName();
        HashSet<String> repoNames = new HashSet<String>(this.repositoryManagerRESTAdapter.findContainingGroups(repositoryName));
        repoNames.add(repositoryName);
        return asset -> this.contentAuthHelper.checkPathPermissions(asset.path(), repository.getFormat().getValue(), repoNames.toArray(new String[0]));
    }
}

