/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.rest.internal.resources;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.entity.DetachedEntityId;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.maintenance.MaintenanceService;
import org.sonatype.nexus.repository.content.rest.AssetXOBuilder;
import org.sonatype.nexus.repository.content.rest.internal.resources.AssetsResourceSupport;
import org.sonatype.nexus.repository.content.rest.internal.resources.doc.AssetsResourceDoc;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.rest.api.AssetXO;
import org.sonatype.nexus.repository.rest.api.AssetXODescriptor;
import org.sonatype.nexus.repository.rest.api.RepositoryItemIDXO;
import org.sonatype.nexus.repository.rest.api.RepositoryManagerRESTAdapter;
import org.sonatype.nexus.repository.selector.ContentAuthHelper;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
@Path(value="/v1/assets")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AssetsResource
extends AssetsResourceSupport
implements Resource,
AssetsResourceDoc {
    static final String RESOURCE_URI = "/v1/assets";
    static final int PAGE_SIZE = 10;
    private final RepositoryManagerRESTAdapter repositoryManagerRESTAdapter;
    private final MaintenanceService maintenanceService;
    private final Map<String, AssetXODescriptor> assetDescriptors;

    @Inject
    public AssetsResource(RepositoryManagerRESTAdapter repositoryManagerRESTAdapter, MaintenanceService maintenanceService, ContentAuthHelper contentAuthHelper, Map<String, AssetXODescriptor> assetDescriptors) {
        super(contentAuthHelper);
        this.repositoryManagerRESTAdapter = (RepositoryManagerRESTAdapter)Preconditions.checkNotNull((Object)repositoryManagerRESTAdapter);
        this.maintenanceService = (MaintenanceService)Preconditions.checkNotNull((Object)maintenanceService);
        this.assetDescriptors = assetDescriptors;
    }

    @Override
    @GET
    public Page<AssetXO> getAssets(@Nullable @QueryParam(value="continuationToken") String continuationToken, @QueryParam(value="repository") String repositoryId) {
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryId);
        List<FluentAsset> assets = this.browse(repository, continuationToken);
        return new Page(AssetsResource.toAssetXOs(repository, assets, this.assetDescriptors), AssetsResource.nextContinuationToken(assets));
    }

    @Override
    @GET
    @Path(value="/{id}")
    public AssetXO getAssetById(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIDXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIDXO.getRepositoryId());
        Asset asset = this.getAsset(id, repository, new DetachedEntityId(repositoryItemIDXO.getId()));
        return AssetXOBuilder.fromAsset(asset, repository, this.assetDescriptors);
    }

    @Override
    @DELETE
    @Path(value="/{id}")
    public void deleteAsset(@PathParam(value="id") String id) {
        RepositoryItemIDXO repositoryItemIDXO = RepositoryItemIDXO.fromString((String)id);
        Repository repository = this.repositoryManagerRESTAdapter.getRepository(repositoryItemIDXO.getRepositoryId());
        DetachedEntityId entityId = new DetachedEntityId(repositoryItemIDXO.getId());
        Asset asset = this.getAsset(id, repository, entityId);
        this.maintenanceService.deleteAsset(repository, asset);
    }

    private Asset getAsset(String id, Repository repository, DetachedEntityId entityId) {
        try {
            return ((ContentFacet)repository.facet(ContentFacet.class)).assets().find((EntityId)entityId).filter(this.assetPermitted(repository.getFormat().getValue(), repository.getName())).orElseThrow(() -> new NotFoundException("Unable to locate asset with id " + id));
        }
        catch (IllegalArgumentException e) {
            this.log.debug("IllegalArgumentException caught retrieving asset with id {}", (Object)entityId, (Object)e);
            throw new WebApplicationException(String.format("Unable to process asset with id %s", entityId), 422);
        }
    }

    private static List<AssetXO> toAssetXOs(Repository repository, List<FluentAsset> assets, Map<String, AssetXODescriptor> assetDescriptors) {
        return assets.stream().map(asset -> AssetXOBuilder.fromAsset(asset, repository, assetDescriptors)).collect(Collectors.toList());
    }

    private static String nextContinuationToken(List<FluentAsset> assets) {
        int size = assets.size();
        return size < 10 ? null : InternalIds.toExternalId(InternalIds.internalAssetId(assets.get(size - 1))).getValue();
    }
}

