/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.replication;

import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.replication.ReplicationUtils;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Singleton
public class ReplicationIngestionService
extends ComponentSupport {
    public FluentComponent replicateComponent(FluentComponents fluentComponents, Map<String, Object> componentAttributes, String name, String version) {
        return this.replicateComponent(fluentComponents, componentAttributes, name, version, null);
    }

    public FluentComponent replicateComponent(FluentComponents fluentComponents, Map<String, Object> componentAttributes, String name, String version, @Nullable String namespace) {
        FluentComponentBuilder componentBuilder = fluentComponents.name(name).version(version);
        if (namespace != null) {
            componentBuilder = componentBuilder.namespace(namespace);
        }
        for (Map.Entry<String, Object> attr : componentAttributes.entrySet()) {
            componentBuilder.attributes(attr.getKey(), attr.getValue());
        }
        return componentBuilder.getOrCreate();
    }

    public void replicateAsset(FluentAssets fluentAssets, String path, Blob blob, Map<String, Object> assetAttributes, String kind) {
        this.replicateAsset(fluentAssets, path, blob, assetAttributes, kind, null);
    }

    public void replicateAsset(FluentAssets fluentAssets, String path, Blob blob, Map<String, Object> assetAttributes, String kind, @Nullable FluentComponent component) {
        FluentAssetBuilder fluentAssetBuilder = fluentAssets.path(path).kind(kind).blob(blob, ReplicationUtils.getChecksumsFromProperties(assetAttributes));
        if (component != null) {
            fluentAssetBuilder = fluentAssetBuilder.component(component);
        }
        FluentAsset asset = fluentAssetBuilder.save();
        AttributeChangeSet changeSet = new AttributeChangeSet();
        assetAttributes.forEach((key, value) -> {
            AttributeChangeSet attributeChangeSet2 = changeSet.attributes(AttributeOperation.SET, (String)key, value);
        });
        asset.attributes(changeSet);
    }
}

