/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.kv.global;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.content.kv.global.ValueType;

public class NexusKeyValue
extends ComponentSupport
implements Serializable {
    private final String VALUE_NESTED_KEY = "value";
    private String key;
    private ValueType type;
    private Map<String, Object> value = new HashMap<String, Object>();

    public NexusKeyValue(String key, ValueType type, Object value) {
        this.key = key;
        this.type = type;
        this.setValue(value);
    }

    public NexusKeyValue() {
    }

    public String key() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ValueType type() {
        return this.type;
    }

    public void setType(ValueType type) {
        this.type = type;
    }

    public Map<String, Object> value() {
        return this.value;
    }

    public void setValue(Map<String, Object> value) {
        this.value = value;
    }

    public void setValue(Object value) {
        this.value.put("value", value);
    }

    public String getAsString() {
        return this.value.get("value").toString();
    }

    public Integer getAsInt() {
        return Integer.parseInt(this.getAsString());
    }

    public Boolean getAsBoolean() {
        return Boolean.parseBoolean(this.getAsString());
    }

    public <T> T getAsObject(ObjectMapper mapper, Class<T> typeClass) {
        return (T)mapper.convertValue(this.value.get("value"), typeClass);
    }

    public <T> List<T> getAsObjectList(ObjectMapper mapper, Class<T> typeClass) {
        return (List)mapper.convertValue(this.value.get("value"), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, typeClass));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NexusKeyValue that = (NexusKeyValue)o;
        return Objects.equals(this.key, that.key) && this.type == that.type && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{"value", this.key, this.type, this.value});
    }
}

