/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.kv.global;

import com.google.common.collect.Iterables;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSession;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.kv.global.KeyValueEvent;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValueDAO;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="mybatis")
@Singleton
public class GlobalKeyValueStore
extends ConfigStoreSupport<NexusKeyValueDAO> {
    @Inject
    public GlobalKeyValueStore(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier, NexusKeyValueDAO.class);
    }

    private DataSession<?> currentSession() {
        return (DataSession)UnitOfWork.currentSession();
    }

    protected NexusKeyValueDAO dao() {
        return (NexusKeyValueDAO)this.currentSession().access(NexusKeyValueDAO.class);
    }

    @Transactional
    public Optional<NexusKeyValue> getKey(String key) {
        return this.dao().get(key);
    }

    @Transactional
    public void setKey(NexusKeyValue keyValue) {
        super.postCommitEvent(() -> new KeyValueEvent(keyValue.key(), Iterables.getOnlyElement(keyValue.value().values())));
        this.dao().set(keyValue);
    }

    @Transactional
    public boolean removeKey(String key) {
        return this.dao().remove(key);
    }
}

