/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.kv;

import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.ibatis.annotations.Param;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.kv.KeyValueDAO;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class KeyValueStore<T extends KeyValueDAO>
extends ContentStoreSupport<T> {
    private static final int DELETE_BATCH_SIZE_DEFAULT = SystemPropertiesHelper.getInteger((String)"nexus.content.deleteBatchSize", (int)1000);

    @Inject
    public KeyValueStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public Optional<String> get(int repositoryId, String type, String key) {
        return ((KeyValueDAO)this.dao()).get(repositoryId, type, key);
    }

    @Transactional
    public void set(int repositoryId, String type, String key, String value) {
        ((KeyValueDAO)this.dao()).set(repositoryId, type, key, value);
    }

    @Transactional
    public void remove(int repositoryId, String type, String key) {
        ((KeyValueDAO)this.dao()).remove(repositoryId, type, key);
    }

    public void removeAll(int repositoryId, @Nullable String category) {
        int count;
        while ((count = this.removeCategoryPage(repositoryId, category)) > 0) {
        }
    }

    @Transactional
    protected int removeCategoryPage(int repositoryId, @Nullable String category) {
        return ((KeyValueDAO)this.dao()).removeAll(repositoryId, category, DELETE_BATCH_SIZE_DEFAULT);
    }

    public void removeRepository(int repositoryId) {
        int count;
        while ((count = this.removeRepositoryPage(repositoryId)) > 0) {
        }
    }

    @Transactional
    protected int removeRepositoryPage(int repositoryId) {
        return ((KeyValueDAO)this.dao()).removeRepository(repositoryId, DELETE_BATCH_SIZE_DEFAULT);
    }

    @Transactional
    public Continuation<KeyValue> browse(int repositoryId, String type, int limit, String continuationToken) {
        return ((KeyValueDAO)this.dao()).browse(repositoryId, type, limit, continuationToken);
    }

    @Transactional
    public List<String> browseCategories(@Param(value="repositoryId") int repositoryId) {
        return ((KeyValueDAO)this.dao()).browseCategories(repositoryId);
    }

    @Transactional
    public int count(int repositoryId, @Nullable String category) {
        return ((KeyValueDAO)this.dao()).count(repositoryId, category);
    }

    @Transactional
    public List<String> findCategories(int repositoryId, String key) {
        return ((KeyValueDAO)this.dao()).findCategories(repositoryId, key);
    }

    @Transactional
    public List<KeyValue> findByCategoryAndKeyLike(int repositoryId, @Nullable String category, String keyLike) {
        return ((KeyValueDAO)this.dao()).findByCategoryAndKeyLike(repositoryId, category, keyLike);
    }
}

