/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.kv;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.kv.KeyValue;
import org.sonatype.nexus.repository.content.kv.KeyValueDAO;
import org.sonatype.nexus.repository.content.kv.KeyValueStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.store.InternalIds;

@Facet.Exposed
public abstract class KeyValueFacetSupport<DAO extends KeyValueDAO, STORE extends KeyValueStore<DAO>>
extends FacetSupport {
    private final String format;
    private final Class<DAO> daoClass;
    private FormatStoreManager formatStoreManager;
    protected STORE dataStore;

    protected KeyValueFacetSupport(String formatName, Class<DAO> daoClass) {
        this.format = (String)Preconditions.checkNotNull((Object)formatName);
        this.daoClass = (Class)Preconditions.checkNotNull(daoClass);
    }

    @Inject
    public void inject(Map<String, FormatStoreManager> formatStoreManagersByFormat) {
        this.formatStoreManager = (FormatStoreManager)Preconditions.checkNotNull((Object)formatStoreManagersByFormat.get(this.format));
    }

    protected void doStart() throws Exception {
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.getRepository().facet(ContentFacet.class);
        String storeName = contentFacet.stores().contentStoreName;
        this.dataStore = (KeyValueStore)((Object)this.formatStoreManager.formatStore(storeName, this.daoClass));
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    protected Optional<String> get(String category, String key) {
        return ((KeyValueStore)((Object)this.dataStore)).get(this.repositoryId(), category, key);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    public List<KeyValue> findByCategoryAndKeyLike(@Nullable String category, String keyLike) {
        return ((KeyValueStore)((Object)this.dataStore)).findByCategoryAndKeyLike(this.repositoryId(), category, keyLike);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    protected void set(String category, String key, String value) {
        ((KeyValueStore)((Object)this.dataStore)).set(this.repositoryId(), category, key, value);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    protected void remove(String category, String key) {
        ((KeyValueStore)((Object)this.dataStore)).remove(this.repositoryId(), category, key);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    public void removeAll(String category) {
        ((KeyValueStore)((Object)this.dataStore)).removeAll(this.repositoryId(), category);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    public void removeAll() {
        ((KeyValueStore)((Object)this.dataStore)).removeAll(this.repositoryId(), null);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    protected Continuation<KeyValue> browseValues(String category, int limit, @Nullable String continuationToken) {
        return ((KeyValueStore)((Object)this.dataStore)).browse(this.repositoryId(), category, limit, continuationToken);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    protected List<String> browseCategories() {
        return ((KeyValueStore)((Object)this.dataStore)).browseCategories(this.repositoryId());
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    public int countValues(String category) {
        return ((KeyValueStore)((Object)this.dataStore)).count(this.repositoryId(), category);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    public int countValues() {
        return ((KeyValueStore)((Object)this.dataStore)).count(this.repositoryId(), null);
    }

    @Guarded(by={"ATTACHED", "STARTED"})
    protected List<String> findCategories(String key) {
        return ((KeyValueStore)((Object)this.dataStore)).findCategories(this.repositoryId(), key);
    }

    protected int repositoryId() {
        return InternalIds.contentRepositoryId(this.getRepository()).orElseThrow(IllegalStateException::new);
    }
}

