/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.internal.purge;

import com.google.common.base.Preconditions;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.store.AssetStore;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.purge.PurgeUnusedFacet;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
public class PurgeUnusedFacetImpl
extends FacetSupport
implements PurgeUnusedFacet {
    @Guarded(by={"STARTED"})
    public void purgeUnused(int numberOfDays) {
        Preconditions.checkArgument((numberOfDays > 0 ? 1 : 0) != 0, (Object)"Number of days must be greater then zero");
        this.log.info("Purging unused components from repository {}", (Object)this.getRepository().getName());
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.getRepository().facet(ContentFacet.class);
        ComponentStore<?> componentStore = contentFacet.stores().componentStore;
        AssetStore<?> assetStore = contentFacet.stores().assetStore;
        int contentRepositoryId = contentFacet.contentRepositoryId();
        int purgedAssets = assetStore.purgeNotRecentlyDownloaded(contentRepositoryId, numberOfDays);
        this.log.debug("Deleted {} unused assets without components", (Object)purgedAssets);
        int purgedComponents = componentStore.purgeNotRecentlyDownloaded(contentRepositoryId, numberOfDays);
        this.log.debug("Deleted {} unused components and their assets", (Object)purgedComponents);
        this.log.info("Purged {} unused components from repository {}", (Object)purgedComponents, (Object)this.getRepository().getName());
    }
}

