/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.internal;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.internal.DatabaseIntegrityChecker;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.UPGRADE)
@FeatureFlag(name="nexus.datastore.enabled")
public class DatabaseIntegrityCheckService
extends LifecycleSupport {
    private final DataSessionSupplier dataSessionSupplier;
    private final List<DatabaseIntegrityChecker> databaseIntegrityCheckers;

    @Inject
    public DatabaseIntegrityCheckService(DataSessionSupplier dataSessionSupplier, List<DatabaseIntegrityChecker> databaseIntegrityCheckers) {
        this.dataSessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)dataSessionSupplier);
        this.databaseIntegrityCheckers = (List)Preconditions.checkNotNull(databaseIntegrityCheckers);
    }

    protected void doStart() throws Exception {
        Connection connection = this.dataSessionSupplier.openConnection("nexus");
        for (DatabaseIntegrityChecker checker : this.databaseIntegrityCheckers) {
            checker.checkAndRepair(connection);
        }
    }
}

