/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.internal;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.content.internal.DatabaseIntegrityChecker;
import org.sonatype.nexus.repository.content.kv.global.GlobalKeyValueStore;
import org.sonatype.nexus.repository.content.kv.global.NexusKeyValue;
import org.sonatype.nexus.repository.content.kv.global.ValueType;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.upgrade.datastore.DatabaseMigrationUtility;

@Named
@Singleton
public class ComponentNormalizationIntegrityChecker
extends ComponentSupport
implements DatabaseIntegrityChecker {
    private final String TABLE_NAME = "%s_component";
    private final String COLUMN_NAME = "normalized_version";
    private final String INDEX_NAME = "idx_%s_normalized_version";
    private final String ADD_COLUMN_STATEMENT = String.format("ALTER TABLE %s ADD COLUMN IF NOT EXISTS %s VARCHAR;", "%s_component", "normalized_version");
    private final String ADD_INDEX_STATEMENT = "CREATE INDEX IF NOT EXISTS %s ON %s (normalized_version)";
    private final List<Format> formats;
    private final TaskScheduler taskScheduler;
    private final UpgradeTaskScheduler startupScheduler;
    private final Map<String, FormatStoreManager> managersByFormat;
    private final GlobalKeyValueStore globalKeyValueStore;
    private final DatabaseMigrationUtility databaseMigrationUtility;

    @Inject
    public ComponentNormalizationIntegrityChecker(List<Format> formats, TaskScheduler taskScheduler, UpgradeTaskScheduler startupScheduler, Map<String, FormatStoreManager> managersByFormat, GlobalKeyValueStore globalKeyValueStore, DatabaseMigrationUtility databaseMigrationUtility) {
        this.formats = (List)Preconditions.checkNotNull(formats);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.startupScheduler = (UpgradeTaskScheduler)Preconditions.checkNotNull((Object)startupScheduler);
        this.managersByFormat = (Map)Preconditions.checkNotNull(managersByFormat);
        this.globalKeyValueStore = (GlobalKeyValueStore)((Object)Preconditions.checkNotNull((Object)((Object)globalKeyValueStore)));
        this.databaseMigrationUtility = (DatabaseMigrationUtility)Preconditions.checkNotNull((Object)databaseMigrationUtility);
    }

    @Override
    public void checkAndRepair(Connection connection) throws SQLException {
        boolean needsNormalization;
        this.log.info("validating normalized_version columns");
        this.alterFormats(connection);
        Set<Format> formatsNeedingNormalization = this.formats.stream().filter(format -> !((ComponentStore)((Object)((Object)this.managersByFormat.get(format.getValue()).componentStore("nexus")))).browseUnnormalized(1, null).isEmpty()).collect(Collectors.toSet());
        boolean bl = needsNormalization = !formatsNeedingNormalization.isEmpty();
        if (needsNormalization) {
            this.log.info("Formats detected needing normalization {}", formatsNeedingNormalization);
            formatsNeedingNormalization.forEach(this::markFormatAsNeedingNormalization);
            this.scheduleTask();
        }
    }

    private void markFormatAsNeedingNormalization(Format format) {
        NexusKeyValue kv = new NexusKeyValue();
        kv.setKey(this.getFormatKey(format));
        kv.setType(ValueType.BOOLEAN);
        kv.setValue(false);
        this.globalKeyValueStore.setKey(kv);
    }

    private void scheduleTask() {
        this.startupScheduler.schedule(this.taskScheduler.createTaskConfigurationInstance("component.normalize.version"));
    }

    private void alterFormats(Connection connection) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement alterStmt = connection.createStatement();){
            for (Format format : this.formats) {
                this.alter(connection, alterStmt, format);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void alter(Connection connection, Statement alterStatement, Format format) throws SQLException {
        String formatName = format.getValue();
        String tableName = String.format("%s_component", formatName).toUpperCase();
        if (!this.databaseMigrationUtility.tableExists(connection, tableName)) {
            this.log.debug("{} component table not found", (Object)formatName);
            throw new SQLException("Unable to repair " + tableName + " because it wasn't yet created");
        }
        if (!this.databaseMigrationUtility.columnExists(connection, tableName, "normalized_version")) {
            this.log.info("adding missing column '{}' to {} format", (Object)"normalized_version", (Object)formatName);
            alterStatement.execute(String.format(this.ADD_COLUMN_STATEMENT, formatName));
            if (!this.databaseMigrationUtility.indexExists(connection, String.format("idx_%s_normalized_version", formatName))) {
                this.log.info("adding missing index '{}' to {} format", (Object)String.format("idx_%s_normalized_version", formatName), (Object)formatName);
                alterStatement.execute(String.format("CREATE INDEX IF NOT EXISTS %s ON %s (normalized_version)", String.format("idx_%s_normalized_version", formatName), tableName));
            }
        }
    }

    private String getFormatKey(Format format) {
        return String.format("%s.normalized.version.available", format.getValue());
    }
}

