/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.handlers;

import com.google.common.base.Preconditions;
import java.time.OffsetDateTime;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.time.UTC;
import org.sonatype.nexus.repository.capability.GlobalRepositorySettings;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

@Named
@Singleton
public class LastDownloadedHandler
extends ComponentSupport
implements org.sonatype.nexus.repository.view.handlers.LastDownloadedHandler {
    private final GlobalRepositorySettings globalSettings;

    @Inject
    public LastDownloadedHandler(GlobalRepositorySettings globalSettings) {
        this.globalSettings = (GlobalRepositorySettings)Preconditions.checkNotNull((Object)globalSettings);
    }

    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        try {
            if (this.isSuccessfulRequestWithContent(context, response)) {
                Content content = (Content)response.getPayload();
                this.maybeUpdateLastDownloaded(content.getAttributes());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to update last downloaded time for request {}", (Object)context.getRequest().getPath(), (Object)e);
        }
        return response;
    }

    protected void maybeUpdateLastDownloaded(AttributesMap attributes) {
        this.maybeUpdateLastDownloaded((Asset)attributes.get(Asset.class));
    }

    protected void maybeUpdateLastDownloaded(@Nullable Asset asset) {
        if (asset != null && !this.isNextUpdateInFuture(asset.lastDownloaded())) {
            if (asset instanceof FluentAsset) {
                ((FluentAsset)asset).markAsDownloaded();
            } else {
                this.log.debug("Cannot mark read-only asset {} as downloaded", (Object)asset.path());
            }
        }
    }

    private boolean isNextUpdateInFuture(Optional<OffsetDateTime> lastTime) {
        return lastTime.isPresent() && lastTime.get().plus(this.globalSettings.getLastDownloadedInterval()).isAfter(UTC.now());
    }

    private boolean isSuccessfulRequestWithContent(Context context, Response response) {
        return this.isGetOrHeadRequest(context) && this.isSuccessfulOrNotModified(response.getStatus()) && response.getPayload() instanceof Content;
    }

    private boolean isGetOrHeadRequest(Context context) {
        String action = context.getRequest().getAction();
        return "GET".equals(action) || "HEAD".equals(action);
    }

    private boolean isSuccessfulOrNotModified(Status status) {
        return status.isSuccessful() || status.getCode() == 304;
    }
}

