/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.constraints.FluentQueryConstraint;

final class RepositoryContentUtil {
    private RepositoryContentUtil() {
    }

    static boolean isGroupRepository(Repository repository) {
        return "group".equals(repository.getType().getValue());
    }

    static Set<Integer> getRepositoryIds(@Nullable List<FluentQueryConstraint> constraints, ContentFacet contentFacet, Repository repository) {
        if (constraints == null || constraints.isEmpty()) {
            return Collections.singleton(contentFacet.contentRepositoryId());
        }
        Set<Integer> repositoryIds = constraints.stream().map(constraint -> constraint.getRepositoryIds(repository)).flatMap(Collection::stream).collect(Collectors.toSet());
        constraints.forEach(constraint -> {
            boolean bl = repositoryIds.addAll(constraint.getRepositoryIds(repository));
        });
        if (repositoryIds.isEmpty()) {
            repositoryIds.add(contentFacet.contentRepositoryId());
        }
        return repositoryIds;
    }
}

