/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.ComponentSet;
import org.sonatype.nexus.repository.content.SqlGenerator;
import org.sonatype.nexus.repository.content.SqlQueryParameters;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.fluent.FluentContinuation;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.fluent.constraints.FluentQueryConstraint;
import org.sonatype.nexus.repository.content.fluent.constraints.GroupRepositoryConstraint;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentBuilderImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentQueryImpl;
import org.sonatype.nexus.repository.content.fluent.internal.RepositoryContentUtil;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ComponentSetData;
import org.sonatype.nexus.repository.content.store.ComponentStore;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.types.GroupType;

public class FluentComponentsImpl
implements FluentComponents {
    private final ContentFacetSupport facet;
    private final ComponentStore<?> componentStore;

    public FluentComponentsImpl(ContentFacetSupport facet, ComponentStore<?> componentStore) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.componentStore = (ComponentStore)((Object)Preconditions.checkNotNull(componentStore));
    }

    @Override
    public FluentComponentBuilder name(String name) {
        return new FluentComponentBuilderImpl(this.facet, this.componentStore, name);
    }

    @Override
    public FluentComponent with(Component component) {
        return component instanceof FluentComponent ? (FluentComponent)component : new FluentComponentImpl(this.facet, component);
    }

    @Override
    public FluentComponent with(Component component, @Nullable Collection<Asset> assets) {
        if (component instanceof FluentComponent) {
            return (FluentComponent)component;
        }
        if (assets == null) {
            return new FluentComponentImpl(this.facet, component, null);
        }
        List<FluentAsset> fluentAssets = assets.stream().map(it -> this.facet.assets().with((Asset)it)).collect(Collectors.toList());
        return new FluentComponentImpl(this.facet, component, fluentAssets);
    }

    @Override
    public int count() {
        return this.doCount(null, null, null);
    }

    int doCount(@Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return this.componentStore.countComponents(this.facet.contentRepositoryId(), kind, filter, filterParams);
    }

    @Override
    public Continuation<FluentComponent> browse(int limit, String continuationToken) {
        ArrayList<FluentQueryConstraint> constraints = new ArrayList<FluentQueryConstraint>();
        if (RepositoryContentUtil.isGroupRepository(this.facet.repository())) {
            constraints.add(new GroupRepositoryConstraint(GroupRepositoryConstraint.GroupRepositoryLocation.LOCAL));
        }
        return this.doBrowse(limit, continuationToken, null, null, null, constraints);
    }

    @Override
    public Continuation<FluentComponent> browseEager(int limit, @Nullable String continuationToken) {
        return this.doBrowseEager(limit, continuationToken, null, null, null);
    }

    Continuation<FluentComponent> doBrowseEager(int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        Set<Integer> repositoryIds = RepositoryContentUtil.getRepositoryIds(null, this.facet, this.facet.repository());
        Continuation<ComponentData> componentAssetsData = this.componentStore.browseComponentsEager(repositoryIds, limit, continuationToken, kind, filter, filterParams);
        return new FluentContinuation(componentAssetsData, componentData -> {
            assert (componentData != null);
            List<Asset> assets = componentData.getAssets();
            return this.facet.components().with((Component)componentData, (Collection<Asset>)assets);
        });
    }

    Continuation<FluentComponent> doBrowse(int limit, @Nullable String continuationToken, @Nullable String kind, @Nullable String filter, @Nullable Map<String, Object> filterParams, @Nullable List<FluentQueryConstraint> constraints) {
        Set<Integer> repositoryIds = RepositoryContentUtil.getRepositoryIds(constraints, this.facet, this.facet.repository());
        if (repositoryIds.size() > 1) {
            return new FluentContinuation(this.componentStore.browseComponents(repositoryIds, limit, continuationToken), this::with);
        }
        return new FluentContinuation(this.componentStore.browseComponents(repositoryIds.iterator().next(), limit, continuationToken, kind, filter, filterParams), this::with);
    }

    @Override
    public FluentQuery<FluentComponent> withGroupMemberContent() {
        return new FluentComponentQueryImpl(this, Collections.singletonList(new GroupRepositoryConstraint(GroupRepositoryConstraint.GroupRepositoryLocation.BOTH)));
    }

    @Override
    public FluentQuery<FluentComponent> withOnlyGroupMemberContent() {
        return new FluentComponentQueryImpl(this, Collections.singletonList(new GroupRepositoryConstraint(GroupRepositoryConstraint.GroupRepositoryLocation.MEMBERS)));
    }

    @Override
    public FluentQuery<FluentComponent> byKind(String kind) {
        return new FluentComponentQueryImpl(this, kind);
    }

    @Override
    public FluentQuery<FluentComponent> byFilter(String filter, Map<String, Object> filterParams) {
        return new FluentComponentQueryImpl(this, filter, filterParams);
    }

    @Override
    public Continuation<FluentComponent> bySet(ComponentSet componentSet, int limit, String continuationToken) {
        return new FluentContinuation(this.componentStore.browseComponentsBySet(this.facet.contentRepositoryId(), componentSet, limit, continuationToken), this::with);
    }

    @Override
    public Continuation<FluentComponent> selectComponents(SqlGenerator<? extends SqlQueryParameters> generator, SqlQueryParameters params) {
        return new FluentContinuation(this.componentStore.selectComponents(generator, params), this::with);
    }

    @Override
    public Continuation<FluentComponent> selectComponentsWithAssets(SqlGenerator<? extends SqlQueryParameters> generator, SqlQueryParameters params) {
        return new FluentContinuation(this.componentStore.selectComponentsWithAssets(generator, params), this::with);
    }

    @Override
    public Collection<String> namespaces() {
        return this.componentStore.browseNamespaces(this.facet.contentRepositoryId());
    }

    @Override
    public Collection<String> names(String namespace) {
        return this.componentStore.browseNames(this.facet.contentRepositoryId(), namespace);
    }

    @Override
    public Continuation<ComponentSetData> sets(int limit, String continuationToken) {
        return this.componentStore.browseSets(this.facet.contentRepositoryId(), limit, continuationToken);
    }

    @Override
    public Collection<String> versions(String namespace, String name) {
        return this.componentStore.browseVersions(this.facet.contentRepositoryId(), namespace, name);
    }

    @Override
    public Optional<FluentComponent> find(EntityId externalId) {
        return this.componentStore.readComponent(InternalIds.toInternalId(externalId)).filter(this::containedInRepository).map(component -> new FluentComponentImpl(this.facet, (Component)component));
    }

    private boolean containedInRepository(Component component) {
        int expectedContentRepositoryId = InternalIds.contentRepositoryId(component);
        if (expectedContentRepositoryId == this.facet.contentRepositoryId()) {
            return true;
        }
        if (this.facet.repository().getType() instanceof GroupType) {
            return ((GroupFacet)this.facet.repository().facet(GroupFacet.class)).allMembers().stream().map(InternalIds::contentRepositoryId).filter(Optional::isPresent).map(Optional::get).anyMatch(id -> id == expectedContentRepositoryId);
        }
        return false;
    }
}

