/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssetBuilder;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetBuilderImpl;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetImpl;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.WrappedContent;

public class FluentComponentImpl
implements FluentComponent,
WrappedContent<Component> {
    private final ContentFacetSupport facet;
    private final Component component;
    private final Collection<FluentAsset> assets;

    public FluentComponentImpl(ContentFacetSupport facet, Component component) {
        this(facet, component, null);
    }

    public FluentComponentImpl(ContentFacetSupport facet, Component component, @Nullable Collection<FluentAsset> assets) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.component = (Component)Preconditions.checkNotNull((Object)component);
        this.assets = assets == null ? null : Collections.unmodifiableCollection(assets);
    }

    @Override
    public Repository repository() {
        return this.facet.repository();
    }

    @Override
    public String namespace() {
        return this.component.namespace();
    }

    @Override
    public String name() {
        return this.component.name();
    }

    @Override
    public String kind() {
        return this.component.kind();
    }

    @Override
    public String version() {
        return this.component.version();
    }

    @Override
    public String normalizedVersion() {
        return this.component.normalizedVersion();
    }

    @Override
    public Integer entityVersion() {
        return this.component.entityVersion();
    }

    @Override
    public NestedAttributesMap attributes() {
        return this.component.attributes();
    }

    @Override
    public OffsetDateTime created() {
        return this.component.created();
    }

    @Override
    public OffsetDateTime lastUpdated() {
        return this.component.lastUpdated();
    }

    @Override
    public FluentComponent attributes(AttributeOperation change, String key, Object value) {
        this.facet.stores().componentStore.updateComponentAttributes(this.component, change, key, value);
        return this;
    }

    @Override
    public FluentAssetBuilder asset(String path) {
        return new FluentAssetBuilderImpl(this.facet, this.facet.stores().assetStore, path).component(this);
    }

    @Override
    public Collection<FluentAsset> assets() {
        if (this.assets != null) {
            return this.assets;
        }
        return Collections2.transform(this.facet.stores().assetStore.browseComponentAssets(this.component), asset -> new FluentAssetImpl(this.facet, (Asset)asset));
    }

    @Override
    public FluentComponent kind(String kind) {
        if (!Objects.equals(kind, this.component.kind())) {
            ((ComponentData)this.component).setKind(kind);
            this.facet.stores().componentStore.updateComponentKind(this.component);
        }
        return this;
    }

    @Override
    public boolean delete() {
        return this.facet.stores().componentStore.deleteComponent(this.component);
    }

    @Override
    public Component unwrap() {
        return this.component;
    }

    public String toString() {
        return this.toStringExternal();
    }
}

