/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponentBuilder;
import org.sonatype.nexus.repository.content.fluent.internal.FluentComponentImpl;
import org.sonatype.nexus.repository.content.store.ComponentData;
import org.sonatype.nexus.repository.content.store.ComponentStore;

public class FluentComponentBuilderImpl
implements FluentComponentBuilder {
    private final ContentFacetSupport facet;
    private final ComponentStore<?> componentStore;
    private final String name;
    private String kind = "";
    private String namespace = "";
    private String version = "";
    private String normalizedVersion = "";
    private Map<String, Object> attributes;

    public FluentComponentBuilderImpl(ContentFacetSupport facet, ComponentStore<?> componentStore, String name) {
        this.facet = (ContentFacetSupport)Preconditions.checkNotNull((Object)facet);
        this.componentStore = (ComponentStore)((Object)Preconditions.checkNotNull(componentStore));
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Override
    public FluentComponentBuilder namespace(String namespace) {
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace);
        return this;
    }

    @Override
    public FluentComponentBuilder kind(String kind) {
        this.kind = (String)Preconditions.checkNotNull((Object)kind);
        return this;
    }

    @Override
    public FluentComponentBuilder kind(Optional<String> optionalKind) {
        optionalKind.ifPresent(k -> {
            String string = this.kind = k;
        });
        return this;
    }

    @Override
    public FluentComponentBuilder version(String version) {
        this.version = (String)Preconditions.checkNotNull((Object)version);
        return this;
    }

    @Override
    public FluentComponentBuilder normalizedVersion(String normalizedVersion) {
        this.normalizedVersion = (String)Preconditions.checkNotNull((Object)normalizedVersion);
        return this;
    }

    @Override
    public FluentComponentBuilder attributes(String key, Object value) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value);
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public FluentComponent getOrCreate() {
        return new FluentComponentImpl(this.facet, this.componentStore.getOrCreate(this::findComponent, this::createComponent));
    }

    @Override
    public Optional<FluentComponent> find() {
        return this.findComponent().map(component -> new FluentComponentImpl(this.facet, (Component)component));
    }

    private Optional<Component> findComponent() {
        return this.componentStore.readCoordinate(this.facet.contentRepositoryId(), this.namespace, this.name, this.version);
    }

    private Component createComponent() {
        ComponentData component = new ComponentData();
        component.setRepositoryId(this.facet.contentRepositoryId());
        component.setNamespace(this.namespace);
        component.setName(this.name);
        component.setKind(this.kind);
        component.setVersion(this.version);
        component.setNormalizedVersion(this.normalizedVersion);
        if (this.attributes != null && !this.attributes.isEmpty()) {
            component.attributes().backing().putAll(this.attributes);
        }
        this.componentStore.createComponent(component);
        return component;
    }
}

