/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.fluent.constraints.FluentQueryConstraint;
import org.sonatype.nexus.repository.content.fluent.internal.FluentAssetsImpl;

public class FluentAssetQueryImpl
implements FluentQuery<FluentAsset> {
    private final FluentAssetsImpl assets;
    private final String kind;
    private final String filter;
    private final Map<String, Object> filterParams;
    private final List<FluentQueryConstraint> constraints;

    FluentAssetQueryImpl(FluentAssetsImpl assets, List<FluentQueryConstraint> constraints) {
        this.assets = (FluentAssetsImpl)Preconditions.checkNotNull((Object)assets);
        this.constraints = (List)Preconditions.checkNotNull(constraints);
        this.filter = null;
        this.filterParams = null;
        this.kind = null;
    }

    FluentAssetQueryImpl(FluentAssetsImpl assets, String kind) {
        this.assets = (FluentAssetsImpl)Preconditions.checkNotNull((Object)assets);
        this.kind = (String)Preconditions.checkNotNull((Object)kind);
        this.filter = null;
        this.filterParams = null;
        this.constraints = Collections.emptyList();
    }

    FluentAssetQueryImpl(FluentAssetsImpl assets, String filter, Map<String, Object> filterParams) {
        this.assets = (FluentAssetsImpl)Preconditions.checkNotNull((Object)assets);
        this.kind = null;
        this.filter = (String)Preconditions.checkNotNull((Object)filter);
        this.filterParams = (Map)Preconditions.checkNotNull(filterParams);
        this.constraints = Collections.emptyList();
    }

    @Override
    public int count() {
        return this.assets.doCount(this.kind, this.filter, this.filterParams);
    }

    @Override
    public Continuation<FluentAsset> browse(int limit, String continuationToken) {
        return this.assets.doBrowse(limit, continuationToken, this.kind, this.filter, this.filterParams, this.constraints);
    }

    @Override
    public Continuation<FluentAsset> browseEager(int limit, @Nullable String continuationToken) {
        throw new UnsupportedOperationException();
    }
}

