/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.fluent.constraints;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.ContentRepository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.constraints.FluentQueryConstraint;
import org.sonatype.nexus.repository.group.GroupFacet;

public class GroupRepositoryConstraint
implements FluentQueryConstraint {
    private final GroupRepositoryLocation groupRepositoryLocation;

    public GroupRepositoryConstraint(GroupRepositoryLocation groupRepositoryLocation) {
        this.groupRepositoryLocation = (GroupRepositoryLocation)((Object)Preconditions.checkNotNull((Object)((Object)groupRepositoryLocation)));
    }

    @Override
    public Set<Integer> getRepositoryIds(Repository repository) {
        HashSet<Integer> repositoryIds = new HashSet<Integer>();
        switch (this.groupRepositoryLocation) {
            case LOCAL: {
                repositoryIds.add(((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId());
                break;
            }
            case MEMBERS: {
                repositoryIds.addAll(this.getLeafRepositoryIds(repository));
                break;
            }
            case BOTH: {
                repositoryIds.add(((ContentFacet)repository.facet(ContentFacet.class)).contentRepositoryId());
                repositoryIds.addAll(this.getLeafRepositoryIds(repository));
            }
        }
        return repositoryIds;
    }

    private Set<Integer> getLeafRepositoryIds(Repository repository) {
        return ((GroupFacet)repository.facet(GroupFacet.class)).leafMembers().stream().map(leafRepository -> (ContentFacet)leafRepository.facet(ContentFacet.class)).map(ContentRepository::contentRepositoryId).collect(Collectors.toSet());
    }

    public static GroupRepositoryConstraint of(GroupRepositoryLocation groupRepositoryLocation) {
        return new GroupRepositoryConstraint(groupRepositoryLocation);
    }

    public static enum GroupRepositoryLocation {
        LOCAL,
        MEMBERS,
        BOTH;

    }
}

