/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.facet;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.facet.AssetBlobValidators;
import org.sonatype.nexus.repository.move.RepositoryMoveService;
import org.sonatype.nexus.repository.search.normalize.VersionNormalizerService;
import org.sonatype.nexus.repository.storage.BlobMetadataStorage;
import org.sonatype.nexus.security.ClientInfoProvider;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Singleton
public class ContentFacetDependencies {
    private final BlobStoreManager blobStoreManager;
    private final DataSessionSupplier dataSessionSupplier;
    private final ConstraintViolationFactory constraintViolationFactory;
    private final ClientInfoProvider clientInfoProvider;
    private final NodeAccess nodeAccess;
    private final AssetBlobValidators assetBlobValidators;
    private final BlobMetadataStorage blobMetadataStorage;
    private final VersionNormalizerService versionNormalizerService;
    private final Optional<RepositoryMoveService> maybeMoveService;

    @Inject
    public ContentFacetDependencies(BlobStoreManager blobStoreManager, DataSessionSupplier dataSessionSupplier, ConstraintViolationFactory constraintViolationFactory, ClientInfoProvider clientInfoProvider, NodeAccess nodeAccess, AssetBlobValidators assetBlobValidators, BlobMetadataStorage blobMetadataStorage, VersionNormalizerService versionNormalizerService, @Nullable RepositoryMoveService moveService) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.dataSessionSupplier = (DataSessionSupplier)Preconditions.checkNotNull((Object)dataSessionSupplier);
        this.constraintViolationFactory = (ConstraintViolationFactory)Preconditions.checkNotNull((Object)constraintViolationFactory);
        this.clientInfoProvider = (ClientInfoProvider)Preconditions.checkNotNull((Object)clientInfoProvider);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.assetBlobValidators = (AssetBlobValidators)Preconditions.checkNotNull((Object)assetBlobValidators);
        this.blobMetadataStorage = (BlobMetadataStorage)Preconditions.checkNotNull((Object)blobMetadataStorage);
        this.versionNormalizerService = versionNormalizerService;
        this.maybeMoveService = Optional.ofNullable(moveService);
    }

    public BlobStoreManager getBlobStoreManager() {
        return this.blobStoreManager;
    }

    public DataSessionSupplier getDataSessionSupplier() {
        return this.dataSessionSupplier;
    }

    public ConstraintViolationFactory getConstraintViolationFactory() {
        return this.constraintViolationFactory;
    }

    public ClientInfoProvider getClientInfoProvider() {
        return this.clientInfoProvider;
    }

    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    public AssetBlobValidators getAssetBlobValidators() {
        return this.assetBlobValidators;
    }

    public BlobMetadataStorage getBlobMetadataStorage() {
        return this.blobMetadataStorage;
    }

    public VersionNormalizerService getVersionNormalizerService() {
        return this.versionNormalizerService;
    }

    public Optional<RepositoryMoveService> getMoveService() {
        return this.maybeMoveService;
    }
}

