/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.error;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MissingAssetException
extends RuntimeException {
    private final List<String> UNSUPPORTED_FORMATS = Arrays.asList("docker");
    private final String assetPath;
    private final String format;
    private final boolean isWritableMember;
    private final String repositoryName;
    private final String componentName;
    private final String message;

    public MissingAssetException(String assetPath, String format, boolean isWritableMember, String repositoryName, String componentName) {
        this.assetPath = assetPath;
        this.format = format;
        this.isWritableMember = isWritableMember;
        this.repositoryName = repositoryName;
        this.componentName = componentName;
        this.message = this.buildMessage();
    }

    private String buildMessage() {
        String message = String.format("missing asset with path '%s'", this.assetPath);
        if (this.isWritableMember && this.UNSUPPORTED_FORMATS.contains(this.format)) {
            message = String.format("%s, %s", message, String.format("staging moves are not supported for hosted repositories that are configured as the writable member for a %s group repository.", this.format));
        }
        return message;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getAssetPath() {
        return this.assetPath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public Map<String, String> getData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("path", this.assetPath);
        data.put("component", this.componentName);
        data.put("repository", this.repositoryName);
        return data;
    }
}

