/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse.store;

import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeDAO;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeData;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named
public class BrowseNodeStore<T extends BrowseNodeDAO>
extends ContentStoreSupport<T> {
    @Inject
    public BrowseNodeStore(DataSessionSupplier sessionSupplier, @Assisted String contentStoreName, @Assisted Class<T> daoClass) {
        super(sessionSupplier, contentStoreName, daoClass);
    }

    @Transactional
    public List<BrowseNode> getByDisplayPath(int repositoryId, List<String> displayPath, int limit, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return ((BrowseNodeDAO)this.dao()).getByDisplayPath(repositoryId, displayPath, limit, filter, filterParams);
    }

    @Transactional
    public boolean hasComponentNode(int componentId) {
        return ((BrowseNodeDAO)this.dao()).hasComponentNode(componentId);
    }

    @Transactional
    public boolean hasAssetNode(int assetId) {
        return ((BrowseNodeDAO)this.dao()).hasAssetNode(assetId);
    }

    @Transactional
    public void mergeBrowseNode(BrowseNodeData browseNode) {
        ((BrowseNodeDAO)this.dao()).mergeBrowseNode(browseNode);
    }

    @Transactional
    public boolean trimBrowseNodes(int repositoryId) {
        this.log.debug("Removing unused browse nodes in repository {}", (Object)repositoryId);
        boolean trimmed = false;
        while (((BrowseNodeDAO)this.dao()).trimBrowseNodes(repositoryId)) {
            this.commitChangesSoFar();
            trimmed = true;
        }
        this.log.debug("Removed unused browse nodes in repository {}", (Object)repositoryId);
        return trimmed;
    }

    @Transactional
    public boolean deleteBrowseNodes(int repositoryId) {
        this.log.debug("Deleting all browse nodes in repository {}", (Object)repositoryId);
        boolean deleted = false;
        while (((BrowseNodeDAO)this.dao()).deleteBrowseNodes(repositoryId, this.deleteBatchSize())) {
            this.commitChangesSoFar();
            deleted = true;
        }
        this.log.debug("Deleted all browse nodes in repository {}", (Object)repositoryId);
        return deleted;
    }
}

