/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse.store;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authz.Permission;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.template.EscapeHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.node.BrowseListItem;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowseNodeComparator;
import org.sonatype.nexus.repository.browse.node.BrowseNodeFilter;
import org.sonatype.nexus.repository.browse.node.BrowseNodeIdentity;
import org.sonatype.nexus.repository.browse.node.BrowseNodeQueryService;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeData;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetFinder;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.security.RepositoryViewPermission;
import org.sonatype.nexus.repository.selector.ContentAuthHelper;
import org.sonatype.nexus.repository.types.GroupType;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.selector.SelectorConfiguration;
import org.sonatype.nexus.selector.SelectorFilterBuilder;
import org.sonatype.nexus.selector.SelectorManager;

@Named
@Singleton
public class BrowseNodeQueryServiceImpl
extends StateGuardLifecycleSupport
implements BrowseNodeQueryService {
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy");
    private static final EscapeHelper escapeHelper = new EscapeHelper();
    private final SecurityHelper securityHelper;
    private final SelectorManager selectorManager;
    private final Map<String, BrowseNodeFilter> browseNodeFilters;
    private final Map<String, BrowseNodeIdentity> browseNodeIdentities;
    private final Map<String, BrowseNodeComparator> browseNodeComparators;
    private final BrowseNodeComparator defaultBrowseNodeComparator;
    private final ContentAuthHelper contentAuthHelper;
    private final SelectorFilterBuilder selectorFilterBuilder;

    @Inject
    public BrowseNodeQueryServiceImpl(SecurityHelper securityHelper, SelectorManager selectorManager, Map<String, BrowseNodeFilter> browseNodeFilters, Map<String, BrowseNodeIdentity> browseNodeIdentities, Map<String, BrowseNodeComparator> browseNodeComparators, ContentAuthHelper contentAuthHelper, SelectorFilterBuilder selectorFilterBuilder) {
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
        this.selectorManager = (SelectorManager)Preconditions.checkNotNull((Object)selectorManager);
        this.browseNodeFilters = (Map)Preconditions.checkNotNull(browseNodeFilters);
        this.browseNodeIdentities = (Map)Preconditions.checkNotNull(browseNodeIdentities);
        this.browseNodeComparators = (Map)Preconditions.checkNotNull(browseNodeComparators);
        this.defaultBrowseNodeComparator = (BrowseNodeComparator)Preconditions.checkNotNull((Object)browseNodeComparators.get("default"));
        this.contentAuthHelper = (ContentAuthHelper)Preconditions.checkNotNull((Object)contentAuthHelper);
        this.selectorFilterBuilder = (SelectorFilterBuilder)Preconditions.checkNotNull((Object)selectorFilterBuilder);
    }

    public Iterable<BrowseNode> getByPath(Repository repository, List<String> displayPath, int maxNodes) {
        List<Object> results;
        String repositoryName = repository.getName();
        String format = repository.getFormat().getValue();
        List selectors = Collections.emptyList();
        if (!this.hasBrowsePermission(repositoryName, format) && (selectors = this.selectorManager.browseActive(Arrays.asList(repositoryName), Arrays.asList(format))).isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Object> filterParameters = new HashMap<String, Object>();
        String contentFilter = this.buildContentAuthFilter(repository, selectors, filterParameters);
        boolean hasJexl = selectors.stream().anyMatch(this::isJexl);
        if (repository.getType() instanceof GroupType) {
            int repositoryId = InternalIds.contentRepositoryId(repository).orElse(-1);
            BrowseNodeIdentity identity = this.browseNodeIdentities.getOrDefault(format, BrowseNode::getName);
            Equivalence browseNodeEquivalence = Equivalence.equals().onResultOf(arg_0 -> ((BrowseNodeIdentity)identity).identity(arg_0));
            BrowseNodeFilter filter = this.browseNodeFilters.getOrDefault(format, (node, name) -> true);
            results = BrowseNodeQueryServiceImpl.members(repository).map(m -> this.selectByPath((Repository)m, displayPath, maxNodes, contentFilter, (Map<String, Object>)filterParameters, hasJexl)).flatMap(Collection::stream).map(arg_0 -> ((Equivalence)browseNodeEquivalence).wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).filter(node -> filter.test(node, (Object)(repositoryId == ((BrowseNodeData)node).repositoryId ? 1 : 0))).limit(maxNodes).collect(Collectors.toList());
        } else {
            results = this.selectByPath(repository, displayPath, maxNodes, contentFilter, filterParameters, hasJexl);
        }
        results.sort(this.getBrowseNodeComparator(format));
        return results;
    }

    private List<BrowseNode> selectByPath(Repository repository, List<String> displayPath, int maxNodes, @Nullable String contentFilter, @Nullable Map<String, Object> filterParams, boolean hasJexl) {
        List nodes = repository.optionalFacet(BrowseFacet.class).map(facet -> facet.getByDisplayPath(displayPath, maxNodes, contentFilter, filterParams)).orElse((List)ImmutableList.of());
        if (hasJexl) {
            String repositoryName = repository.getName();
            String format = repository.getFormat().getValue();
            nodes = nodes.stream().filter(node -> this.contentAuthHelper.checkPathPermissionsJexlOnly(node.getPath(), format, new String[]{repositoryName})).collect(Collectors.toList());
        }
        return nodes;
    }

    private boolean hasBrowsePermission(String repositoryName, String format) {
        return this.securityHelper.anyPermitted(new Permission[]{new RepositoryViewPermission(format, repositoryName, new String[]{"browse"})});
    }

    private static Stream<Repository> members(Repository repository) {
        return ((GroupFacet)repository.facet(GroupFacet.class)).allMembers().stream();
    }

    private Comparator<BrowseNode> getBrowseNodeComparator(String format) {
        return (Comparator)this.browseNodeComparators.getOrDefault(format, this.defaultBrowseNodeComparator);
    }

    private boolean isJexl(SelectorConfiguration selectorConfiguration) {
        return "jexl".equals(selectorConfiguration.getType());
    }

    @Nullable
    private String buildContentAuthFilter(Repository repository, List<SelectorConfiguration> selectors, Map<String, Object> filterParameters) {
        return this.selectorFilterBuilder.buildFilter(repository.getFormat().getValue(), "B.request_path", selectors, filterParameters);
    }

    public List<BrowseListItem> toListItems(Repository repository, Iterable<BrowseNode> nodes) {
        ArrayList<BrowseListItem> items = new ArrayList<BrowseListItem>();
        if (nodes == null) {
            return items;
        }
        for (BrowseNode node : nodes) {
            String link;
            String lastModified = null;
            String size = null;
            if (node.isLeaf()) {
                Optional<FluentAsset> asset = this.getAssetById(repository, node.getAssetId());
                if (!asset.isPresent()) {
                    this.log.error("Could not find expected asset (id): {} ({}) in repository: {}", new Object[]{node.getPath(), node.getAssetId(), repository.getName()});
                    continue;
                }
                Optional<AssetBlob> blob = asset.get().blob();
                if (blob.isPresent()) {
                    lastModified = DATE_TIME_FORMAT.format(blob.get().blobCreated().toZonedDateTime());
                    size = Long.toString(blob.get().blobSize());
                }
                link = this.getAssetLink(repository, asset.get());
            } else {
                link = String.valueOf(escapeHelper.uri(node.getName())) + '/';
            }
            items.add(new BrowseListItem(link, node.getName(), !node.isLeaf(), lastModified, size, ""));
        }
        return items;
    }

    private Optional<FluentAsset> getAssetById(Repository repository, @Nullable EntityId assetId) {
        if (assetId == null) {
            return Optional.empty();
        }
        return ContentFacetFinder.findContentFacets(repository).map(ContentFacet::assets).map(facet -> facet.find(assetId)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private String getAssetLink(Repository repository, Asset asset) {
        return String.valueOf(repository.getUrl()) + Stream.of(asset.path().split("/")).map(arg_0 -> ((EscapeHelper)escapeHelper).uri(arg_0)).collect(Collectors.joining("/"));
    }
}

