/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse.store;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeDAO;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeData;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeStore;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.transaction.Transactional;

public class BrowseNodeManager
extends ComponentSupport {
    private final BrowseNodeStore<BrowseNodeDAO> browseNodeStore;
    private final int repositoryId;

    public BrowseNodeManager(BrowseNodeStore<BrowseNodeDAO> browseNodeStore, int repositoryId) {
        this.browseNodeStore = (BrowseNodeStore)((Object)Preconditions.checkNotNull(browseNodeStore));
        this.repositoryId = repositoryId;
    }

    public List<BrowseNode> getByDisplayPath(List<String> displayPath, int limit, @Nullable String filter, @Nullable Map<String, Object> filterParams) {
        return this.browseNodeStore.getByDisplayPath(this.repositoryId, displayPath, limit, filter, filterParams);
    }

    public boolean hasComponentNode(Component component) {
        return this.browseNodeStore.hasComponentNode(InternalIds.internalComponentId(component));
    }

    public boolean hasAssetNode(Asset asset) {
        return this.browseNodeStore.hasAssetNode(InternalIds.internalAssetId(asset));
    }

    public void createBrowseNodes(List<BrowsePath> paths, Consumer<BrowseNodeData> finalStep) {
        Transactional.operation.withStore(this.browseNodeStore).run(() -> this.doCreateBrowseNodes(paths, finalStep));
    }

    protected void doCreateBrowseNodes(List<BrowsePath> paths, Consumer<BrowseNodeData> finalStep) {
        Long parentId = null;
        int i = 0;
        while (i < paths.size()) {
            BrowseNodeData node = new BrowseNodeData();
            node.setRepositoryId(this.repositoryId);
            node.setRequestPath(paths.get(i).getRequestPath());
            node.setDisplayName(paths.get(i).getDisplayName());
            if (parentId != null) {
                node.setParentId(parentId);
            }
            if (i == paths.size() - 1) {
                finalStep.accept(node);
            }
            try {
                this.browseNodeStore.mergeBrowseNode(node);
            }
            catch (DuplicateKeyException e) {
                this.log.warn("Duplicate key for browse node found (repositoryId = {}, name = {}, path = {}), all paths = [{}]; a rebuild will likely be necessary after migration is complete", new Object[]{this.repositoryId, node.getName(), node.getPath(), paths.stream().map(path -> "(" + path.getDisplayName() + ", " + path.getRequestPath() + ")").collect(Collectors.joining(", ")), e});
                return;
            }
            parentId = node.nodeId;
            ++i;
        }
    }

    public void trimBrowseNodes() {
        this.browseNodeStore.trimBrowseNodes(this.repositoryId);
    }

    public void deleteBrowseNodes() {
        this.browseNodeStore.deleteBrowseNodes(this.repositoryId);
    }
}

