/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Named;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.browse.node.BrowsePathBuilder;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.ComponentPathBrowseNodeGenerator;

@Singleton
@Named(value="default")
public class DefaultBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public static final String NAME = "default";

    @Override
    public List<BrowsePath> computeAssetPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        if (asset.component().isPresent()) {
            List<BrowsePath> paths = this.computeComponentPaths(asset);
            String lastSegment = this.lastSegment(asset.path());
            BrowsePathBuilder.appendPath(paths, (String)lastSegment);
            return paths;
        }
        return super.computeAssetPaths(asset);
    }

    @Override
    public List<BrowsePath> computeComponentPaths(Asset asset) {
        Preconditions.checkNotNull((Object)asset);
        ArrayList<String> paths = new ArrayList<String>();
        Preconditions.checkArgument((boolean)asset.component().isPresent());
        Component component = asset.component().get();
        if (!Strings2.isBlank((String)component.namespace())) {
            paths.add(component.namespace());
        }
        paths.add(component.name());
        if (!Strings2.isBlank((String)component.version())) {
            paths.add(component.version());
        }
        return BrowsePathBuilder.fromPaths(paths, (boolean)true);
    }
}

