/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.logging.task.ProgressLogIntervalHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.browse.node.BrowseNode;
import org.sonatype.nexus.repository.browse.node.BrowsePath;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeDAO;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeData;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeManager;
import org.sonatype.nexus.repository.content.browse.store.BrowseNodeStore;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.repository.ossindex.PackageUrlService;
import org.sonatype.nexus.scheduling.CancelableHelper;

@Named
public class BrowseFacetImpl
extends FacetSupport
implements BrowseFacet {
    private static final int COMPONENT_ID_CACHE_SIZE = 10000;
    private static final float CACHE_MAP_DEFAULT_LOAD_FACTOR = 0.75f;
    private static final boolean CACHE_MAP_RETAIN_ACCESS_ORDER = true;
    private final Map<String, FormatStoreManager> formatStoreManagersByFormat;
    private final Map<String, BrowseNodeGenerator> browseNodeGeneratorsByFormat;
    private final PackageUrlService packageUrlService;
    private final int pageSize;
    private String format;
    private BrowseNodeGenerator browseNodeGenerator;
    private BrowseNodeManager browseNodeManager;

    @Inject
    public BrowseFacetImpl(Map<String, FormatStoreManager> formatStoreManagersByFormat, Map<String, BrowseNodeGenerator> browseNodeGeneratorsByFormat, PackageUrlService packageUrlService, @Named(value="${nexus.browse.rebuild.pageSize:-1000}") @Named(value="${nexus.browse.rebuild.pageSize:-1000}") int pageSize) {
        this.formatStoreManagersByFormat = (Map)Preconditions.checkNotNull(formatStoreManagersByFormat);
        this.browseNodeGeneratorsByFormat = (Map)Preconditions.checkNotNull(browseNodeGeneratorsByFormat);
        this.packageUrlService = (PackageUrlService)Preconditions.checkNotNull((Object)packageUrlService);
        this.pageSize = Math.max(pageSize, 1);
    }

    protected void doStart() throws Exception {
        ContentFacetSupport contentFacet = (ContentFacetSupport)this.getRepository().facet(ContentFacet.class);
        this.format = this.getRepository().getFormat().getValue();
        String storeName = contentFacet.stores().contentStoreName;
        int repositoryId = contentFacet.contentRepositoryId();
        BrowseNodeStore browseNodeStore = (BrowseNodeStore)((Object)this.lookupFormatStoreManager(this.format).formatStore(storeName, BrowseNodeDAO.class));
        this.browseNodeGenerator = this.lookupBrowseNodeGenerator(this.format);
        this.browseNodeManager = new BrowseNodeManager(browseNodeStore, repositoryId);
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<BrowseNode> getByDisplayPath(List<String> displayPath, int limit, String filter, Map<String, Object> filterParams) {
        return this.browseNodeManager.getByDisplayPath(displayPath, limit, filter, filterParams);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void addPathsToAssets(Collection<EntityId> assetIds) {
        FluentAssets lookup = ((ContentFacet)this.facet(ContentFacet.class)).assets();
        Map<Integer, Integer> componentsProcessed = this.newComponentCache();
        assetIds.stream().map(lookup::find).filter(Optional::isPresent).map(Optional::get).filter(fluentAsset -> !this.browseNodeManager.hasAssetNode((Asset)fluentAsset)).forEach(fluentAsset -> this.createBrowseNodes((FluentAsset)fluentAsset, componentsProcessed));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void trimBrowseNodes() {
        this.browseNodeManager.trimBrowseNodes();
    }

    @Override
    @Guarded(by={"STARTED"})
    public void rebuildBrowseNodes(Consumer<String> progressUpdater) {
        this.log.info("Deleting browse nodes for repository {}", (Object)this.getRepository().getName());
        this.browseNodeManager.deleteBrowseNodes();
        this.log.info("Rebuilding browse nodes for repository {}", (Object)this.getRepository().getName());
        this.createAllBrowseNodes(progressUpdater);
    }

    private void createAllBrowseNodes(Consumer<String> progressUpdater) {
        String repositoryName = this.getRepository().getName();
        try {
            FluentAssets assets = ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets();
            long total = assets.count();
            if (total > 0L) {
                Map<Integer, Integer> processedComponents = this.newComponentCache();
                ProgressLogIntervalHelper progressLogger = new ProgressLogIntervalHelper(this.log, 60);
                Stopwatch sw = Stopwatch.createStarted();
                long processed = 0L;
                Continuation page = assets.browse(this.pageSize, null);
                while (!page.isEmpty()) {
                    page.forEach(fluentAsset -> this.createBrowseNodes((FluentAsset)fluentAsset, processedComponents));
                    long elapsed = sw.elapsed(TimeUnit.MILLISECONDS);
                    progressLogger.info("Processed {} / {} {} assets in {} ms", new Object[]{processed += (long)page.size(), total, repositoryName, elapsed});
                    if (progressUpdater != null) {
                        long percentageComplete = BigDecimal.valueOf(processed).divide(BigDecimal.valueOf(total), 2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).longValue();
                        progressUpdater.accept(String.format("%d%% Complete", percentageComplete));
                    }
                    CancelableHelper.checkCancellation();
                    page = assets.browse(this.pageSize, page.nextContinuationToken());
                }
                progressLogger.flush();
            }
        }
        catch (Exception e) {
            this.log.error("Unable to rebuild browse nodes for repository {}", (Object)repositoryName, (Object)e);
        }
    }

    private void createBrowseNodes(FluentAsset asset, Map<Integer, Integer> componentsProcessed) {
        if (this.browseNodeGenerator.hasMultipleAssetsPerComponent()) {
            this.createAssetBrowseNodes(asset);
            asset.component().ifPresent(component -> this.createComponentBrowseNodes(asset, (Component)component, componentsProcessed));
        } else {
            this.createCombinedAssetAndComponentBrowseNodes(asset);
        }
    }

    private void createAssetBrowseNodes(FluentAsset asset) {
        List<BrowsePath> assetPaths = this.browseNodeGenerator.computeAssetPaths(asset);
        if (!assetPaths.isEmpty()) {
            this.browseNodeManager.createBrowseNodes(assetPaths, (BrowseNodeData node) -> node.setAsset(asset));
        }
    }

    private void createComponentBrowseNodes(FluentAsset asset, Component component, Map<Integer, Integer> componentsProcessed) {
        List<BrowsePath> componentPaths;
        Integer internalComponentId = InternalIds.internalComponentId(component);
        if (componentsProcessed.put(internalComponentId, internalComponentId) == null && !(componentPaths = this.browseNodeGenerator.computeComponentPaths(asset)).isEmpty()) {
            this.browseNodeManager.createBrowseNodes(componentPaths, (BrowseNodeData node) -> {
                node.setComponent(component);
                this.findPackageUrl(component).map(PackageUrl::toString).ifPresent(node::setPackageUrl);
            });
        }
    }

    private void createCombinedAssetAndComponentBrowseNodes(FluentAsset asset) {
        List<BrowsePath> assetPaths = this.browseNodeGenerator.computeAssetPaths(asset);
        if (!assetPaths.isEmpty()) {
            this.browseNodeManager.createBrowseNodes(assetPaths, (BrowseNodeData node) -> {
                node.setAsset(asset);
                asset.component().ifPresent(component -> {
                    node.setComponent((Component)component);
                    this.findPackageUrl((Component)component).map(PackageUrl::toString).ifPresent(node::setPackageUrl);
                });
            });
        }
    }

    private Optional<PackageUrl> findPackageUrl(Component component) {
        return this.packageUrlService.getPackageUrl(this.format, component.namespace(), component.name(), component.version());
    }

    private FormatStoreManager lookupFormatStoreManager(String format) {
        FormatStoreManager storeManager = this.formatStoreManagersByFormat.get(format);
        Preconditions.checkState((storeManager != null ? 1 : 0) != 0, (String)"Could not find a store manager for format: %s", (Object)format);
        return storeManager;
    }

    private BrowseNodeGenerator lookupBrowseNodeGenerator(String format) {
        BrowseNodeGenerator generator = this.browseNodeGeneratorsByFormat.get(format);
        if (generator == null) {
            generator = this.browseNodeGeneratorsByFormat.get("default");
        }
        Preconditions.checkState((generator != null ? 1 : 0) != 0, (String)"Could not find a browse node generator for format: %s", (Object)format);
        return generator;
    }

    private Map<Integer, Integer> newComponentCache() {
        return new LinkedHashMap<Integer, Integer>(10000, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 10000;
            }
        };
    }
}

