/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.browse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.browse.node.BrowseNodeEventHandler;
import org.sonatype.nexus.repository.browse.node.BrowseNodeEventHandlerSupport;
import org.sonatype.nexus.repository.content.browse.BrowseFacet;
import org.sonatype.nexus.repository.content.event.asset.AssetCreatedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetPurgedEvent;
import org.sonatype.nexus.repository.content.event.asset.AssetUploadedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.store.ContentStoreEvent;
import org.sonatype.nexus.repository.content.store.InternalIds;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@FeatureFlag(name="nexus.datastore.enabled")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Named
@Singleton
public class BrowseEventHandler
extends BrowseNodeEventHandlerSupport
implements BrowseNodeEventHandler,
EventAware {
    private static final String HANDLER_KEY_PREFIX = "nexus.browse.event.handler.";
    private static final String FLUSH_ON_COUNT_KEY = "nexus.browse.event.handler.flushOnCount";
    private static final String FLUSH_ON_SECONDS_KEY = "nexus.browse.event.handler.flushOnSeconds";
    private static final String NO_PURGE_DELAY_KEY = "nexus.browse.event.handler.noPurgeDelay";
    private final PeriodicJobService periodicJobService;
    private final EventManager eventManager;
    private final int flushOnCount;
    private final int flushOnSeconds;
    private final boolean noPurgeDelay;
    private final FlushEventReceiver flushEventReceiver = new FlushEventReceiver();
    private final Map<String, Repository> pendingAssets = new ConcurrentHashMap<String, Repository>();
    private final AtomicInteger pendingCount = new AtomicInteger();
    private final Set<Repository> repositoriesToTrim = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean needsTrim = new AtomicBoolean();
    private final Cooperation2 cooperation;
    private Object flushMutex = new Object();
    private PeriodicJobService.PeriodicJob flushTask;

    @Inject
    public BrowseEventHandler(Cooperation2Factory cooperation2Factory, PeriodicJobService periodicJobService, EventManager eventManager, @Named(value="${nexus.browse.cooperation.enabled:-true}") @Named(value="${nexus.browse.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.browse.cooperation.majorTimeout:-0s}") @Named(value="${nexus.browse.cooperation.majorTimeout:-0s}") Duration majorTimeout, @Named(value="${nexus.browse.cooperation.minorTimeout:-30s}") @Named(value="${nexus.browse.cooperation.minorTimeout:-30s}") Duration minorTimeout, @Named(value="${nexus.browse.event.handler.flushOnCount:-100}") @Named(value="${nexus.browse.event.handler.flushOnCount:-100}") int flushOnCount, @Named(value="${nexus.browse.event.handler.flushOnSeconds:-2}") @Named(value="${nexus.browse.event.handler.flushOnSeconds:-2}") int flushOnSeconds, @Named(value="${nexus.browse.event.handler.noPurgeDelay:-true}") @Named(value="${nexus.browse.event.handler.noPurgeDelay:-true}") boolean noPurgeDelay) {
        this.cooperation = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperation2Factory)).configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).enabled(cooperationEnabled).build(((Object)((Object)this)).getClass(), new String[0]);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        Preconditions.checkArgument((flushOnCount > 0 ? 1 : 0) != 0, (Object)"nexus.browse.event.handler.flushOnCount must be positive");
        this.flushOnCount = flushOnCount;
        Preconditions.checkArgument((flushOnSeconds > 0 ? 1 : 0) != 0, (Object)"nexus.browse.event.handler.flushOnSeconds must be positive");
        this.flushOnSeconds = flushOnSeconds;
        this.noPurgeDelay = noPurgeDelay;
        eventManager.register((Object)this.flushEventReceiver);
    }

    protected void doStart() throws Exception {
        if (this.flushOnCount > 1) {
            this.periodicJobService.startUsing();
            this.flushTask = this.periodicJobService.schedule(this::pollBrowseUpdateRequests, this.flushOnSeconds);
        }
    }

    protected void doStop() throws Exception {
        if (this.flushOnCount > 1) {
            this.flushTask.cancel();
            this.periodicJobService.stopUsing();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetCreatedEvent event) {
        if (this.shouldHandle()) {
            this.markAssetAsPending(event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetUploadedEvent event) {
        if (this.shouldHandle()) {
            this.markAssetAsPending(event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetDeletedEvent event) {
        if (this.shouldHandle()) {
            this.markRepositoryForTrimming(event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(AssetPurgedEvent event) {
        if (this.shouldHandle()) {
            this.markRepositoryForTrimming(event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentDeletedEvent event) {
        if (this.shouldHandle()) {
            this.markRepositoryForTrimming(event);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(ComponentPurgedEvent event) {
        if (this.shouldHandle()) {
            this.markRepositoryForTrimming(event);
        }
    }

    private void markAssetAsPending(AssetEvent event) {
        Optional<Repository> repository = event.getRepository();
        if (!repository.isPresent()) {
            this.log.debug("Missing repository for event {}", (Object)event);
            return;
        }
        if (this.pendingAssets.put(this.requestKey(event), repository.get()) == null) {
            this.pendingCount.getAndIncrement();
        }
        if (this.pendingCount.getAndUpdate(c -> c >= this.flushOnCount ? c - this.flushOnCount : c) >= this.flushOnCount) {
            this.eventManager.post((Object)new FlushEvent());
        }
    }

    private void markRepositoryForTrimming(ContentStoreEvent event) {
        Optional<Repository> repository = event.getRepository();
        if (!repository.isPresent()) {
            this.log.debug("Unable to determine repository for trimming for event {}", (Object)event);
            return;
        }
        this.repositoriesToTrim.add(repository.get());
        this.needsTrim.set(true);
        if (this.noPurgeDelay) {
            this.eventManager.post((Object)new PurgeEvent());
        }
    }

    void pollBrowseUpdateRequests() {
        if (this.pendingCount.get() > 0) {
            this.flushPageOfAssets();
        }
        this.maybeTrimRepositories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushPageOfAssets() {
        ArrayListMultimap requestsByRepository = ArrayListMultimap.create();
        Object object = this.flushMutex;
        synchronized (object) {
            Iterator<Map.Entry<String, Repository>> itr = this.pendingAssets.entrySet().iterator();
            int i = 0;
            while (i < this.flushOnCount && itr.hasNext()) {
                Map.Entry<String, Repository> entry = itr.next();
                requestsByRepository.put((Object)entry.getValue(), (Object)this.assetId(entry.getKey()));
                itr.remove();
                ++i;
            }
            requestsByRepository.asMap().forEach((repository, assetIds) -> {
                try {
                    this.cooperation.on(() -> {
                        repository.optionalFacet(BrowseFacet.class).ifPresent(browseFacet -> browseFacet.addPathsToAssets((Collection<EntityId>)assetIds));
                        return null;
                    }).checkFunction(Optional::empty).cooperate(repository.getName(), new String[0]);
                }
                catch (IOException e) {
                    this.logWarning("An error occurred while processing browse nodes for {}", (Repository)repository, e);
                }
            });
        }
    }

    void maybeTrimRepositories() {
        if (this.needsTrim.getAndSet(false)) {
            Iterator<Repository> itr = this.repositoriesToTrim.iterator();
            while (itr.hasNext()) {
                Repository nextRepository = itr.next();
                itr.remove();
                try {
                    this.cooperation.on(() -> {
                        nextRepository.optionalFacet(BrowseFacet.class).ifPresent(BrowseFacet::trimBrowseNodes);
                        return null;
                    }).checkFunction(Optional::empty).cooperate(nextRepository.getName(), new String[0]);
                }
                catch (IOException e) {
                    this.logWarning("An error occurred while trying to trim {}", nextRepository, e);
                }
            }
        }
    }

    private void logWarning(String message, Repository repository, Exception e) {
        if (this.log.isDebugEnabled()) {
            this.log.warn(message, (Object)repository.getName(), (Object)e);
        } else {
            this.log.warn(String.valueOf(message) + " - {}", (Object)repository.getName(), (Object)e.getMessage());
        }
    }

    private String requestKey(AssetEvent event) {
        return String.valueOf(event.getFormat()) + ':' + InternalIds.internalAssetId(event.getAsset());
    }

    private EntityId assetId(String requestKey) {
        return InternalIds.toExternalId(Integer.parseInt(requestKey.substring(requestKey.indexOf(58) + 1)));
    }

    private static class FlushEvent {
        private FlushEvent() {
        }
    }

    private class FlushEventReceiver
    implements EventAware.Asynchronous {
        private FlushEventReceiver() {
        }

        @AllowConcurrentEvents
        @Subscribe
        public void on(FlushEvent event) {
            BrowseEventHandler.this.flushPageOfAssets();
        }

        @AllowConcurrentEvents
        @Subscribe
        public void on(PurgeEvent event) {
            BrowseEventHandler.this.maybeTrimRepositories();
        }
    }

    private static class PurgeEvent {
        private PurgeEvent() {
        }
    }
}

