/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content.blobstore.metrics;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsEntity;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsStore;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.repository.content.blobstore.metrics.BlobStoreMetricsDAO;
import org.sonatype.nexus.transaction.Transactional;

@Named
@Singleton
public class BlobStoreMetricsStoreImpl
extends ConfigStoreSupport<BlobStoreMetricsDAO>
implements BlobStoreMetricsStore {
    @Inject
    protected BlobStoreMetricsStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier, BlobStoreMetricsDAO.class);
    }

    @Transactional
    public void updateMetrics(BlobStoreMetricsEntity blobStoreMetricsEntity) {
        ((BlobStoreMetricsDAO)this.dao()).updateMetrics(blobStoreMetricsEntity);
    }

    @Transactional
    public BlobStoreMetricsEntity get(String blobStoreName) {
        return ((BlobStoreMetricsDAO)this.dao()).get(blobStoreName);
    }

    @Transactional
    public void remove(String blobStoreName) {
        ((BlobStoreMetricsDAO)this.dao()).remove(blobStoreName);
    }

    @Transactional
    public void clearOperationMetrics(String blobStoreName) {
        ((BlobStoreMetricsDAO)this.dao()).clearOperationMetrics(blobStoreName);
    }

    @Transactional
    public void clearCountMetrics(String blobStoreName) {
        ((BlobStoreMetricsDAO)this.dao()).clearCountMetrics(blobStoreName);
    }

    @Transactional
    public void initializeMetrics(String blobStoreName) {
        try {
            if (((BlobStoreMetricsDAO)this.dao()).get(blobStoreName) == null) {
                ((BlobStoreMetricsDAO)this.dao()).initializeMetrics(blobStoreName);
            }
        }
        catch (DuplicateKeyException e) {
            this.log.debug("Failed to initialize blobstore metrics as they are already initialized.", (Throwable)e);
        }
    }
}

