/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.content;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.content.AttributeChangeSet;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.RepositoryContent;

public class AttributesHelper {
    private AttributesHelper() {
    }

    public static boolean applyAttributeChange(RepositoryContent content, AttributeOperation change, String key, @Nullable Object value) {
        return AttributesHelper.applyAttributeChange((AttributesMap)content.attributes(), change, key, value);
    }

    public static boolean applyAttributeChange(AttributesMap attributes, AttributeChangeSet.AttributeChange change) {
        return AttributesHelper.applyAttributeChange(attributes, change.getOperation(), change.getKey(), change.getValue());
    }

    public static boolean applyAttributeChange(AttributesMap attributes, AttributeOperation change, String key, @Nullable Object value) {
        switch (change) {
            case SET: {
                return !value.equals(attributes.set(key, Preconditions.checkNotNull((Object)value)));
            }
            case REMOVE: {
                return attributes.remove(key) != null;
            }
            case APPEND: {
                attributes.compute(key, v -> AttributesHelper.append(v, Preconditions.checkNotNull((Object)value)));
                return true;
            }
            case PREPEND: {
                attributes.compute(key, v -> AttributesHelper.prepend(v, Preconditions.checkNotNull((Object)value)));
                return true;
            }
            case OVERLAY: {
                Object oldMap = attributes.get(key);
                Object newMap = AttributesHelper.overlay(oldMap, Preconditions.checkNotNull((Object)value));
                if (!newMap.equals(oldMap)) {
                    attributes.set(key, newMap);
                    return true;
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown request");
    }

    private static Object append(Object list, Object value) {
        if (list == null) {
            return Lists.newArrayList((Object[])new Object[]{value});
        }
        Preconditions.checkArgument((boolean)(list instanceof List), (Object)"Cannot append to non-list attribute");
        ((List)list).add(value);
        return list;
    }

    private static Object prepend(Object list, Object value) {
        if (list == null) {
            return Lists.newArrayList((Object[])new Object[]{value});
        }
        Preconditions.checkArgument((boolean)(list instanceof List), (Object)"Cannot prepend to non-list attribute");
        ((List)list).add(0, value);
        return list;
    }

    private static Object overlay(Object map, Object value) {
        Preconditions.checkArgument((boolean)(value instanceof Map), (String)"Conflict: cannot overlay '%s' onto '%s'", (Object)value, (Object)map);
        if (map == null) {
            return value;
        }
        Preconditions.checkArgument((boolean)(map instanceof Map), (String)"Conflict: cannot overlay '%s' onto '%s'", (Object)value, (Object)map);
        HashMap resultMap = (HashMap)map;
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Object oldValue = resultMap.get(entry.getKey());
            Object newValue = entry.getValue();
            if (oldValue instanceof Map && !oldValue.equals(newValue)) {
                newValue = AttributesHelper.overlay(oldValue, newValue);
            }
            if (Objects.equals(oldValue, newValue)) continue;
            if (resultMap == map) {
                resultMap = new HashMap(resultMap);
            }
            resultMap.put(entry.getKey(), newValue);
        }
        return resultMap;
    }
}

