/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.deployment.internal;

import java.util.Arrays;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreManager;

@Named
@Singleton
public class MigrationsProvider {
    private final DataSource dataSource;
    private final Flyway flyway;

    @Inject
    public MigrationsProvider(DataStoreManager dataStoreManager) {
        this.dataSource = ((DataStore)dataStoreManager.get("nexus").orElseThrow(() -> new IllegalStateException("Missing DataStore named: nexus"))).getDataSource();
        this.flyway = Flyway.configure().dataSource(this.dataSource).load();
    }

    public Stream<MigrationInfo> appliedMigrations() {
        return Arrays.stream(this.flyway.info().applied());
    }
}

