/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.deployment.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.pro.systemchecks.deployment.internal.DeploymentValidator;
import com.sonatype.nexus.pro.systemchecks.deployment.internal.MigrationsProvider;
import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import com.sonatype.nexus.pro.systemchecks.heartbeat.upgrade.NodeHeartbeatDatabaseMigrationStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.flywaydb.core.api.MigrationInfo;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.node.datastore.NodeHeartbeat;

@FeatureFlag(name="nexus.datastore.enabled")
@Named
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.UPGRADE)
public class DeploymentValidatorImpl
extends DeploymentValidator {
    private final ObjectMapper mapper;
    private final MigrationsProvider flywayMigrationsProvider;

    @Inject
    public DeploymentValidatorImpl(NodeHeartbeatStore nodeHeartbeatStore, ApplicationVersion applicationVersion, NodeAccess nodeAccess, @Named(value="repository-configuration") @Named(value="repository-configuration") ObjectMapper mapper, MigrationsProvider flywayMigrationsProvider) {
        super(nodeHeartbeatStore, applicationVersion, nodeAccess);
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper);
        this.flywayMigrationsProvider = (MigrationsProvider)Preconditions.checkNotNull((Object)flywayMigrationsProvider);
    }

    @Override
    void validateStandaloneDeployment() {
        List otherNodeHeartbeats = this.getValidRecentHeartBeats().stream().filter(hb -> !hb.nodeInfo().get("nodeId").equals(this.nodeAccess.getId())).collect(Collectors.toList());
        Preconditions.checkState((boolean)otherNodeHeartbeats.isEmpty(), (Object)"unable to perform standalone deployment, recent heartbeats found from different nodes");
    }

    @Override
    void validateClusteredDeployment() {
        if (!this.requiredMigrationApplied()) {
            this.log.debug("Cluster deployment validation does not meet required checks");
            return;
        }
        this.log.debug("Cluster deployment validation started");
        List<NodeHeartbeat> recentHeartbeatData = this.getValidRecentHeartBeats();
        Set<String> nonClusteredNodes = recentHeartbeatData.stream().filter(hb -> (Boolean)hb.nodeInfo().get("clustered") == false).map(hb -> (String)hb.nodeInfo().get("nodeId")).collect(Collectors.toSet());
        if (!nonClusteredNodes.isEmpty()) {
            this.buildAndThrowError(nonClusteredNodes);
        }
    }

    private List<NodeHeartbeat> getValidRecentHeartBeats() {
        return this.getRecentHeartbeats().stream().filter(heartbeat -> !heartbeat.nodeInfo().isEmpty() && heartbeat.nodeInfo().containsKey("nodeId")).collect(Collectors.toList());
    }

    private void buildAndThrowError(Set<String> nonClusteredNodes) {
        try {
            ArrayList<String> inconsistencies = new ArrayList<String>();
            if (!nonClusteredNodes.isEmpty()) {
                inconsistencies.add(String.format("non clustered nodes : %s", this.mapper.writeValueAsString(nonClusteredNodes)));
            }
            StringBuilder errors = new StringBuilder();
            inconsistencies.forEach(i -> {
                StringBuilder stringBuilder2 = errors.append("\n").append((String)i);
            });
            String errorMessage = String.format("unable to perform clustered deployment for node %s , found inconsistencies : %s ", this.nodeAccess.getId(), errors);
            this.log.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        catch (JsonProcessingException exception) {
            this.log.error("unexpected exception:", (Throwable)exception);
            return;
        }
    }

    private boolean requiredMigrationApplied() {
        return this.flywayMigrationsProvider.appliedMigrations().map(MigrationInfo::getDescription).anyMatch(m -> m.equals(NodeHeartbeatDatabaseMigrationStep.class.getSimpleName()));
    }
}

