/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.pro.systemchecks.deployment.internal;

import com.sonatype.nexus.pro.systemchecks.heartbeat.NodeHeartbeatStore;
import java.util.List;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.node.datastore.NodeHeartbeat;

public abstract class DeploymentValidator
extends StateGuardLifecycleSupport {
    protected final NodeHeartbeatStore nodeHeartbeatStore;
    protected final ApplicationVersion applicationVersion;
    protected final NodeAccess nodeAccess;

    public DeploymentValidator(NodeHeartbeatStore nodeHeartbeatStore, ApplicationVersion applicationVersion, NodeAccess nodeAccess) {
        this.nodeHeartbeatStore = nodeHeartbeatStore;
        this.applicationVersion = applicationVersion;
        this.nodeAccess = nodeAccess;
    }

    protected List<NodeHeartbeat> getRecentHeartbeats() {
        return this.nodeHeartbeatStore.getActiveNodes();
    }

    protected String getRunningVersion() {
        return this.applicationVersion.getVersion();
    }

    protected void doStart() throws Exception {
        if (this.nodeAccess.isClustered()) {
            this.validateClusteredDeployment();
        } else {
            this.validateStandaloneDeployment();
        }
    }

    abstract void validateStandaloneDeployment();

    abstract void validateClusteredDeployment();
}

