/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.util;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.p2.AssetKind;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import com.sonatype.nexus.repository.p2.util.P2TempBlobUtils;
import java.io.IOException;
import java.util.regex.Pattern;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class P2PathUtils {
    public static final String PLUGIN_NAME = "pluginName";
    private static final String NAME_VERSION_SEPARATOR = "_";
    private static final String EXTENSION = "extension";
    private static final Pattern P2_INDEX_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?p2.index$");
    private static final Pattern BUNDLE_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?(features|plugins)/.*_\\d+\\.\\d+\\.\\d+(\\.[A-Za-z0-9_-]+)?.*");
    private static final Pattern BINARY_BUNDLE_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?binary/.*");
    private static final Pattern COMPOSITE_CONTENT_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?compositeContent\\.((jar)|(xml))$");
    private static final Pattern COMPOSITE_ARTIFACTS_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?compositeArtifacts\\.((jar)|(xml))$");
    private static final Pattern CONTENT_METADATA_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?content\\.((jar)|(xml)|(xml\\.xz))$");
    private static final Pattern ARTIFACTS_METADATA_PATTERN = Pattern.compile("/?([0-9a-f]{64})?/?artifacts\\.((jar)|(xml)|(xml\\.xz))$");

    private P2PathUtils() {
        throw new UnsupportedOperationException();
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    public static String name(TokenMatcher.State state) {
        return P2PathUtils.match(state, "name");
    }

    public static String filename(TokenMatcher.State state) {
        return String.valueOf(P2PathUtils.name(state)) + '.' + P2PathUtils.extension(state);
    }

    public static String version(TokenMatcher.State state) {
        return P2PathUtils.match(state, "version");
    }

    public static String componentName(TokenMatcher.State state) {
        return P2PathUtils.name(state).split(NAME_VERSION_SEPARATOR)[0];
    }

    public static String componentVersion(TokenMatcher.State state) {
        return P2PathUtils.name(state).split(NAME_VERSION_SEPARATOR)[1];
    }

    public static String extension(TokenMatcher.State state) {
        return P2PathUtils.match(state, EXTENSION);
    }

    public static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    public static P2Attributes toP2Attributes(String path, TokenMatcher.State state) {
        return P2Attributes.builder().componentName(P2PathUtils.componentName(state)).componentVersion(P2PathUtils.version(state)).extension(P2PathUtils.extension(state)).fileName(P2PathUtils.filename(state)).path(path).build();
    }

    public static P2Attributes toP2AttributesBinary(String path, TokenMatcher.State state) {
        return P2Attributes.builder().pluginName(P2PathUtils.name(state)).componentName(P2PathUtils.name(state)).componentVersion(P2PathUtils.version(state)).path(path).build();
    }

    public static AssetKind getAssetKind(String path) {
        if (P2PathUtils.matches(P2_INDEX_PATTERN, path)) {
            return AssetKind.P2_INDEX;
        }
        if (P2PathUtils.matches(BUNDLE_PATTERN, path)) {
            return AssetKind.BUNDLE;
        }
        if (P2PathUtils.matches(BINARY_BUNDLE_PATTERN, path)) {
            return AssetKind.BINARY_BUNDLE;
        }
        if (P2PathUtils.matches(COMPOSITE_CONTENT_PATTERN, path)) {
            return AssetKind.COMPOSITE_CONTENT;
        }
        if (P2PathUtils.matches(COMPOSITE_ARTIFACTS_PATTERN, path)) {
            return AssetKind.COMPOSITE_ARTIFACTS;
        }
        if (P2PathUtils.matches(CONTENT_METADATA_PATTERN, path)) {
            return AssetKind.CONTENT_METADATA;
        }
        if (P2PathUtils.matches(ARTIFACTS_METADATA_PATTERN, path)) {
            return AssetKind.ARTIFACTS_METADATA;
        }
        throw new UnsupportedOperationException("Asset path has not supported asset kind with path: " + path);
    }

    private static boolean matches(Pattern pattern, String string) {
        return pattern.matcher(string).matches();
    }

    public static P2Attributes getAttributesFromBlob(P2TempBlobUtils p2TempBlobUtils, InputStreamSupplier inputSupplier, String blobName) throws IOException {
        AssetKind assetKind = P2PathUtils.getAssetKind(blobName);
        if (AssetKind.BINARY_BUNDLE == assetKind) {
            return P2PathUtils.getBinaryAttributesFromBlobName(blobName, assetKind);
        }
        return P2PathUtils.getPackageAttributesFromBlob(p2TempBlobUtils, inputSupplier, blobName);
    }

    private static P2Attributes getPackageAttributesFromBlob(P2TempBlobUtils p2TempBlobUtils, InputStreamSupplier inputSupplier, String blobName) throws IOException {
        P2Attributes p2Attributes = P2PathUtils.getMinimalAttributes(blobName);
        return p2TempBlobUtils.mergeAttributesFromTempBlob(inputSupplier, p2Attributes);
    }

    public static P2Attributes getMinimalAttributes(String blobName) {
        AssetKind assetKind = P2PathUtils.getAssetKind(blobName);
        return P2Attributes.builder().extension(P2PathUtils.getPackageExtensionFromBlobName(blobName)).assetKind(assetKind).path(blobName).build();
    }

    private static P2Attributes getBinaryAttributesFromBlobName(String blobName, AssetKind assetKind) {
        String version = P2PathUtils.getBinaryVersionFromBlobName(blobName);
        String name = P2PathUtils.getBinaryNameFromBlobName(blobName, version);
        return P2Attributes.builder().componentName(name).componentVersion(version).pluginName(name).assetKind(assetKind).path(blobName).extension(P2PathUtils.getPackageExtensionFromBlobName(blobName)).build();
    }

    private static String getPackageExtensionFromBlobName(String blobName) {
        String[] paths = blobName.split("\\.");
        return paths[paths.length - 1];
    }

    private static String getBinaryNameFromBlobName(String blobName, String version) {
        String[] namePaths = blobName.split("/");
        return namePaths[namePaths.length - 1].replace(NAME_VERSION_SEPARATOR + version, "");
    }

    private static String getBinaryVersionFromBlobName(String blobName) {
        String[] versionPaths = blobName.split(NAME_VERSION_SEPARATOR);
        return versionPaths[versionPaths.length - 1];
    }
}

