/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.upgrade.tasks;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.p2.orient.upgrade.P2Upgrade_1_2;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class P2RewriteCompositeMetadataService
extends LifecycleSupport {
    private final Path markerFile;
    private final TaskScheduler taskScheduler;

    @Inject
    public P2RewriteCompositeMetadataService(ApplicationDirectories directories, TaskScheduler taskScheduler) {
        this.markerFile = new File(directories.getWorkDirectory("db"), P2Upgrade_1_2.MARKER_FILE).toPath();
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    protected void doStart() throws Exception {
        if (Files.exists(this.markerFile, new LinkOption[0])) {
            this.log.info("Scheduling task: {}", (Object)"repository.p2.rewrite-composite-metdata");
            this.taskScheduler.submit(this.taskScheduler.createTaskConfigurationInstance("repository.p2.rewrite-composite-metdata"));
        }
    }
}

