/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.upgrade;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.sonatype.nexus.repository.p2.orient.upgrade.AbstractP2Upgrade;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="p2", from="1.0", to="1.1")
@Dependencies(value={@DependsOn(model="component", version="1.14", checkpoint=true), @DependsOn(model="config", version="1.8", checkpoint=true)})
public class P2Upgrade_1_1
extends AbstractP2Upgrade {
    private static final String REMOVE_UNNECESSARY_SLASH_FROM_ASSET_NAME = "update asset set name = name.subString(1) where bucket = ? and name like '/%'";

    @Inject
    public P2Upgrade_1_1(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        super(configDatabaseInstance, componentDatabaseInstance);
    }

    public void apply() {
        if (P2Upgrade_1_1.hasSchemaClass((Provider)this.configDatabaseInstance, (String)"repository") && P2Upgrade_1_1.hasSchemaClass((Provider)this.componentDatabaseInstance, (String)"asset")) {
            this.updateP2Repositories();
        }
    }

    private void updateP2Repositories() {
        List<String> p2RepositoryNames = this.getP2RepositoryNames();
        if (!p2RepositoryNames.isEmpty()) {
            this.updateP2AssetNames(p2RepositoryNames);
            this.deleteBrowseNodes(p2RepositoryNames);
        }
    }

    private void updateP2AssetNames(List<String> p2RepositoryNames) {
        OCommandSQL updateAssetCommand = new OCommandSQL(REMOVE_UNNECESSARY_SLASH_FROM_ASSET_NAME);
        DatabaseUpgradeSupport.withDatabaseAndClass((Provider)this.componentDatabaseInstance, (String)"asset", (db, type) -> p2RepositoryNames.forEach(repositoryName -> this.bucketFor((ODatabaseDocumentTx)db, (String)repositoryName).ifPresent(bucket -> {
            int updates = (Integer)db.command((OCommandRequest)updateAssetCommand).execute(new Object[]{bucket.getIdentity()});
            if (updates > 0) {
                this.log.info("Updated {} p2 asset(s) names in repository {}: ", (Object)updates, repositoryName);
            }
        })));
    }
}

