/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.internal;

import java.util.Collections;
import java.util.Set;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

public class P2ComponentMaintenance
extends DefaultComponentMaintenanceImpl {
    @Guarded(by={"STARTED"})
    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        EntityId componentId = asset.componentId();
        if (componentId == null) {
            return super.deleteAssetTx(assetId, deleteBlob);
        }
        Component component = tx.findComponent(componentId);
        if (component == null) {
            return Collections.emptySet();
        }
        return this.deleteComponentTx(componentId, deleteBlob).getAssets();
    }
}

