/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.orient.internal;

import com.sonatype.nexus.repository.p2.internal.browse.P2BrowseNodeGeneratorHelper;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.browse.BrowseNodeGenerator;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.MetadataNode;

@Singleton
@Named(value="p2")
@Priority(value=0x7FFFFFFF)
public class OrientP2BrowseNodeGenerator
implements BrowseNodeGenerator {
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        List<BrowsePaths> browsePaths = this.computeComponentPaths(asset, component);
        List<String> assetPaths = P2BrowseNodeGeneratorHelper.splitPath(asset.name());
        browsePaths.addAll(BrowsePaths.fromPaths(Collections.singletonList(assetPaths.get(assetPaths.size() - 1)), (boolean)false));
        return browsePaths;
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, @Nullable Component component) {
        List<String> componentPaths = P2BrowseNodeGeneratorHelper.computeComponentPath(P2BrowseNodeGeneratorHelper.splitPath(asset.name()), Optional.ofNullable(component).map(MetadataNode::name), Optional.ofNullable(component).map(Component::version));
        return BrowsePaths.fromPaths(componentPaths, (boolean)true);
    }
}

