/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.metadata;

import com.sonatype.nexus.repository.p2.AssetKind;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class P2Attributes {
    private String pluginName;
    private String componentName;
    private String componentVersion;
    private String path;
    private String fileName;
    private String extension;
    private AssetKind assetKind;

    private P2Attributes(Builder builder) {
        this.pluginName = builder.pluginName;
        this.componentName = builder.componentName;
        this.componentVersion = builder.componentVersion;
        this.path = builder.path;
        this.fileName = builder.fileName;
        this.extension = builder.extension;
        this.assetKind = builder.assetKind;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        String[] mainP2Properties;
        String kind = Optional.ofNullable(this.assetKind).map(Enum::toString).orElse(null);
        String[] stringArray = mainP2Properties = new String[]{this.pluginName, this.componentName, this.componentVersion, this.path, this.fileName, this.extension, kind};
        int n = mainP2Properties.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assetKind, this.componentName, this.componentVersion, this.extension, this.fileName, this.path, this.pluginName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        P2Attributes other = (P2Attributes)obj;
        return this.assetKind == other.assetKind && Objects.equals(this.componentName, other.componentName) && Objects.equals(this.componentVersion, other.componentVersion) && Objects.equals(this.extension, other.extension) && Objects.equals(this.fileName, other.fileName) && Objects.equals(this.path, other.path) && Objects.equals(this.pluginName, other.pluginName);
    }

    @Nullable
    public String getPluginName() {
        return this.pluginName;
    }

    @Nullable
    public String getComponentName() {
        return this.componentName;
    }

    @Nullable
    public String getComponentVersion() {
        return this.componentVersion;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Nullable
    public String getExtension() {
        return this.extension;
    }

    @Nullable
    public AssetKind getAssetKind() {
        return this.assetKind;
    }

    /* synthetic */ P2Attributes(Builder builder, P2Attributes p2Attributes) {
        this(builder);
    }

    public static class Builder {
        private String pluginName;
        private String componentName;
        private String componentVersion;
        private String path;
        private String fileName;
        private String extension;
        private AssetKind assetKind;

        private Builder() {
        }

        public Builder pluginName(String groupName) {
            this.pluginName = groupName;
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public Builder componentVersion(String componentVersion) {
            this.componentVersion = componentVersion;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder extension(String extension) {
            this.extension = extension;
            return this;
        }

        public Builder assetKind(AssetKind assetKind) {
            this.assetKind = assetKind;
            return this;
        }

        public P2Attributes build() {
            return new P2Attributes(this, null);
        }

        public Builder merge(P2Attributes one, P2Attributes two) {
            Optional<P2Attributes> optTwo = Optional.ofNullable(two);
            this.componentVersion(optTwo.map(P2Attributes::getComponentVersion).orElse(one.getComponentVersion()));
            this.componentName(optTwo.map(P2Attributes::getComponentName).orElse(one.getComponentName()));
            this.pluginName(optTwo.map(P2Attributes::getPluginName).orElse(one.getPluginName()));
            this.path(optTwo.map(P2Attributes::getPath).orElse(one.getPath()));
            this.fileName(optTwo.map(P2Attributes::getFileName).orElse(one.getFileName()));
            this.extension(optTwo.map(P2Attributes::getExtension).orElse(one.getExtension()));
            this.assetKind(optTwo.map(P2Attributes::getAssetKind).orElse(one.getAssetKind()));
            return this;
        }
    }
}

