/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.util;

import com.sonatype.nexus.repository.p2.internal.exception.AttributeParsingException;
import com.sonatype.nexus.repository.p2.internal.util.AttributesParser;
import com.sonatype.nexus.repository.p2.internal.util.JarExtractor;
import com.sonatype.nexus.repository.p2.internal.util.PropertyParser;
import com.sonatype.nexus.repository.p2.internal.util.TempBlobConverter;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import java.io.IOException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.io.InputStreamSupplier;

@Named
@Singleton
public class AttributesParserManifest
implements AttributesParser {
    private static final String MANIFEST_FILE_PREFIX = "META-INF/";
    private static final String BUNDLE_PROPERTIES = "OSGI-INF/l10n/bundle";
    private JarExtractor<Manifest> manifestJarExtractor;
    private PropertyParser propertyParser;

    @Inject
    public AttributesParserManifest(TempBlobConverter tempBlobConverter, PropertyParser propertyParser) {
        this.propertyParser = propertyParser;
        this.manifestJarExtractor = new JarExtractor<Manifest>(tempBlobConverter){

            @Override
            protected Manifest createSpecificEntity(JarInputStream jis, JarEntry jarEntry) throws IOException {
                Manifest manifest = jis.getManifest();
                if (manifest != null) {
                    return manifest;
                }
                return new Manifest(jis);
            }
        };
    }

    @Override
    public P2Attributes getAttributesFromBlob(InputStreamSupplier inputSupplier, String extension) throws IOException, AttributeParsingException {
        P2Attributes.Builder p2AttributesBuilder = P2Attributes.builder();
        Optional<Manifest> manifestJarEntity = this.manifestJarExtractor.getSpecificEntity(inputSupplier, extension, MANIFEST_FILE_PREFIX);
        if (manifestJarEntity.isPresent()) {
            Attributes mainManifestAttributes = manifestJarEntity.get().getMainAttributes();
            String bundleLocalizationValue = mainManifestAttributes.getValue("Bundle-Localization");
            Optional<PropertyResourceBundle> propertiesOpt = this.propertyParser.getBundleProperties(inputSupplier, extension, bundleLocalizationValue == null ? BUNDLE_PROPERTIES : bundleLocalizationValue);
            p2AttributesBuilder.componentName(this.normalizeName(this.propertyParser.extractValueFromProperty(mainManifestAttributes.getValue("Bundle-SymbolicName"), propertiesOpt))).pluginName(this.propertyParser.extractValueFromProperty(mainManifestAttributes.getValue("Bundle-Name"), propertiesOpt)).componentVersion(this.propertyParser.extractValueFromProperty(mainManifestAttributes.getValue("Bundle-Version"), propertiesOpt));
        }
        return p2AttributesBuilder.build();
    }

    private String normalizeName(String name) {
        String resultName = name;
        if (name != null) {
            resultName = name.split(";")[0];
        }
        return resultName;
    }
}

