/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.p2.internal.util;

import com.sonatype.nexus.repository.p2.internal.exception.AttributeParsingException;
import com.sonatype.nexus.repository.p2.internal.util.AttributesParser;
import com.sonatype.nexus.repository.p2.internal.util.JarExtractor;
import com.sonatype.nexus.repository.p2.internal.util.PropertyParser;
import com.sonatype.nexus.repository.p2.internal.util.TempBlobConverter;
import com.sonatype.nexus.repository.p2.metadata.P2Attributes;
import java.io.IOException;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.common.io.SafeXml;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Named
@Singleton
public class AttributesParserFeatureXml
implements AttributesParser {
    private static final String XML_VERSION_PATH = "feature/@version";
    private static final String XML_PLUGIN_NAME_PATH = "feature/@plugin";
    private static final String XML_PLUGIN_ID_PATH = "feature/@id";
    private static final String XML_NAME_PATH = "feature/@label";
    private static final String XML_FILE_NAME = "feature.xml";
    private static final String FEATURE_PROPERTIES = "feature";
    private JarExtractor<Document> documentJarExtractor;
    private PropertyParser propertyParser;
    private final DocumentBuilderFactory documentBuilderFactory;

    @Inject
    public AttributesParserFeatureXml(TempBlobConverter tempBlobConverter, PropertyParser propertyParser) throws ParserConfigurationException {
        this.propertyParser = propertyParser;
        this.documentBuilderFactory = SafeXml.newdocumentBuilderFactory();
        this.documentBuilderFactory.setValidating(false);
        this.documentJarExtractor = new JarExtractor<Document>(tempBlobConverter){

            @Override
            protected Document createSpecificEntity(JarInputStream jis, JarEntry jarEntry) throws IOException, AttributeParsingException {
                try {
                    return AttributesParserFeatureXml.this.documentBuilderFactory.newDocumentBuilder().parse(jis);
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new AttributeParsingException(e);
                }
            }
        };
    }

    @Override
    public P2Attributes getAttributesFromBlob(InputStreamSupplier inputSupplier, String extension) throws IOException, AttributeParsingException {
        P2Attributes.Builder p2AttributesBuilder = P2Attributes.builder();
        Optional<Document> featureXmlOpt = this.documentJarExtractor.getSpecificEntity(inputSupplier, extension, XML_FILE_NAME);
        Optional<PropertyResourceBundle> propertiesOpt = this.propertyParser.getBundleProperties(inputSupplier, extension, FEATURE_PROPERTIES);
        if (featureXmlOpt.isPresent()) {
            Document document = featureXmlOpt.get();
            String pluginId = this.extractValueFromDocument(XML_PLUGIN_NAME_PATH, document);
            if (pluginId == null) {
                pluginId = this.extractValueFromDocument(XML_PLUGIN_ID_PATH, document);
            }
            String componentName = this.propertyParser.extractValueFromProperty(pluginId, propertiesOpt);
            p2AttributesBuilder.componentName(componentName).pluginName(this.propertyParser.extractValueFromProperty(this.extractValueFromDocument(XML_NAME_PATH, document), propertiesOpt)).componentVersion(this.extractValueFromDocument(XML_VERSION_PATH, document));
        }
        return p2AttributesBuilder.build();
    }

    @Nullable
    private String extractValueFromDocument(String path, Document from) throws AttributeParsingException {
        Node node;
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            node = (Node)xPath.evaluate(path, from, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new AttributeParsingException(e);
        }
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }
}

